"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.StyledButtonIcon = void 0;
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _button = _interopRequireDefault(require("../button/button.style"));
var _icon = _interopRequireDefault(require("../icon/icon.style"));
var _themes = require("../../style/themes");
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
const StyledButtonIcon = exports.StyledButtonIcon = _styledComponents.default.div`
  &&& ${_icon.default} {
    color: var(--colorsActionMajorYang100);
    margin-right: 0px;
  }
`;
const StyledSearchButton = _styledComponents.default.div`
  display: inline-flex;
  border-bottom: none;

  & ${_button.default} {
    color: var(--colorsActionMajorYang100);
    border-color: var(--colorsActionMajorTransparent);
    border-bottom-left-radius: var(--borderRadius000);
    border-top-left-radius: var(--borderRadius000);
    border-bottom-right-radius: var(--borderRadius050);
    border-top-right-radius: var(--borderRadius050);

    :hover {
      border-color: var(--colorsActionMajorTransparent);
    }

    width: fit-content;

    ${_icon.default}${_icon.default} {
      color: var(--colorsActionMajorYang100);
    }

    margin: 0px 0px;
    padding-bottom: 3px;

    :focus {
      z-index: ${({
  theme
}) => theme.zIndex.smallOverlay};
    }
  }
`;
StyledSearchButton.defaultProps = {
  theme: _themes.baseTheme
};
var _default = exports.default = StyledSearchButton;