"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _styledComponents = _interopRequireWildcard(require("styled-components"));
var _styledSystem = require("styled-system");
var _fieldHelp = _interopRequireDefault(require("../../__internal__/field-help/field-help.style"));
var _checkbox = _interopRequireDefault(require("../checkbox/checkbox.style"));
var _hiddenCheckableInput = _interopRequireDefault(require("../../__internal__/checkable-input/hidden-checkable-input.style"));
var _checkableInput = require("../../__internal__/checkable-input/checkable-input.style");
var _checkableInputSvgWrapper = _interopRequireDefault(require("../../__internal__/checkable-input/checkable-input-svg-wrapper.style"));
var _label = require("../../__internal__/label/label.style");
var _base = _interopRequireDefault(require("../../style/themes/base"));
var _formField = _interopRequireDefault(require("../../__internal__/form-field/form-field.style"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const RadioButtonStyle = (0, _styledComponents.default)(_checkbox.default)`
  ${({
  disabled,
  fieldHelpInline,
  reverse,
  size,
  inline
}) => (0, _styledComponents.css)`
    margin-bottom: var(--spacing150);

    :last-of-type {
      margin-bottom: 0;
    }

    && ${_formField.default} {
      margin: 0;
    }

    ${_checkableInputSvgWrapper.default} {
      padding: 0;
    }

    ${_checkableInputSvgWrapper.default}, svg {
      border-radius: var(--borderRadiusCircle);
    }

    ${_checkableInput.StyledCheckableInput},
    ${_hiddenCheckableInput.default},
    ${_checkableInputSvgWrapper.default},
    svg {
      height: 16px;
      width: 16px;
    }

    svg {
      padding: 1px;
    }

    circle {
      r: 5;
    }

    ${_label.StyledLabelContainer} {
      flex: 1 1 calc(100% - 44px);
    }

    ${_hiddenCheckableInput.default}:checked + ${_checkableInputSvgWrapper.default} circle {
      fill: var(--colorsUtilityYin090);
    }

    ${disabled && (0, _styledComponents.css)`
      circle {
        fill: var(--colorsUtilityDisabled400);
      }

      ${_hiddenCheckableInput.default}:checked + ${_checkableInputSvgWrapper.default} circle {
        fill: var(--colorsUtilityDisabled600);
      }
    `}

    ${(fieldHelpInline || reverse) && `
      ${_fieldHelp.default} {
        margin-left: 0;
        margin-right: 6px;
      }

      ${_label.StyledLabelContainer} {
        flex: 0 1 auto;
      }
    `}

    ${size === "large" && (0, _styledComponents.css)`
      ${_checkableInput.StyledCheckableInput},
      ${_hiddenCheckableInput.default},
      ${_checkableInputSvgWrapper.default},
      svg {
        height: 24px;
        width: 24px;
      }

      circle {
        r: 3.75;
      }

      ${reverse && (0, _styledComponents.css)`
        ${!fieldHelpInline && `
          ${_fieldHelp.default} {
            padding: 0;
          }
        `}
      `}
    `}

    ${inline && `
      &:not(:first-of-type) {
        margin-left: 32px;
      }
    `}
  `}

  ${_styledSystem.margin};
`;
RadioButtonStyle.defaultProps = {
  theme: _base.default
};
var _default = exports.default = RadioButtonStyle;