"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.RadioButtonGroup = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _tags = _interopRequireDefault(require("../../../__internal__/utils/helpers/tags/tags"));
var _fieldset = _interopRequireDefault(require("../../../__internal__/fieldset"));
var _radioButtonGroup = _interopRequireWildcard(require("../radio-button-group/radio-button-group.style"));
var _radioButtonMapper = _interopRequireDefault(require("../../../__internal__/radio-button-mapper/radio-button-mapper.component"));
var _useIsAboveBreakpoint = _interopRequireDefault(require("../../../hooks/__internal__/useIsAboveBreakpoint"));
var _utils = require("../../../style/utils");
var _tooltipProvider = require("../../../__internal__/tooltip-provider");
var _logger = _interopRequireDefault(require("../../../__internal__/utils/logger"));
var _carbonProvider = require("../../carbon-provider/carbon-provider.component");
var _validationMessage = _interopRequireDefault(require("../../../__internal__/validation-message/validation-message.component"));
var _box = _interopRequireDefault(require("../../box"));
var _textbox = require("../../textbox/textbox.style");
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
let deprecateUncontrolledWarnTriggered = false;
const RadioButtonGroup = props => {
  const {
    children,
    name,
    legend,
    legendHelp,
    error,
    warning,
    info,
    onBlur,
    onChange,
    value,
    inline = false,
    legendInline = false,
    legendWidth,
    legendAlign,
    legendSpacing,
    labelSpacing = 1,
    adaptiveLegendBreakpoint,
    adaptiveSpacingBreakpoint,
    required,
    isOptional,
    tooltipPosition
  } = props;
  const {
    validationRedesignOptIn
  } = (0, _react.useContext)(_carbonProvider.NewValidationContext);
  if (!deprecateUncontrolledWarnTriggered && !onChange) {
    deprecateUncontrolledWarnTriggered = true;
    _logger.default.deprecate("Uncontrolled behaviour in `Radio Button` is deprecated and support will soon be removed. Please make sure all your inputs are controlled.");
  }
  const marginProps = (0, _utils.filterStyledSystemMarginProps)(props);
  const isAboveLegendBreakpoint = (0, _useIsAboveBreakpoint.default)(adaptiveLegendBreakpoint);
  const isAboveSpacingBreakpoint = (0, _useIsAboveBreakpoint.default)(adaptiveSpacingBreakpoint);
  let inlineLegend = legendInline;
  if (adaptiveLegendBreakpoint) {
    inlineLegend = !!isAboveLegendBreakpoint;
  }
  let marginLeft = marginProps.ml;
  if (adaptiveSpacingBreakpoint && !isAboveSpacingBreakpoint) {
    marginLeft = undefined;
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, validationRedesignOptIn ? /*#__PURE__*/_react.default.createElement(_fieldset.default, _extends({
    legend: legend,
    error: error,
    warning: warning,
    info: info,
    inline: inlineLegend,
    legendWidth: legendWidth,
    legendAlign: legendAlign,
    legendSpacing: legendSpacing,
    isRequired: required,
    isOptional: isOptional
  }, (0, _tags.default)("radiogroup", props), marginProps, {
    ml: marginLeft,
    blockGroupBehaviour: !(error || warning)
  }), legendHelp && /*#__PURE__*/_react.default.createElement(_radioButtonGroup.StyledHintText, null, legendHelp), /*#__PURE__*/_react.default.createElement(_box.default, {
    position: "relative"
  }, /*#__PURE__*/_react.default.createElement(_validationMessage.default, {
    error: error,
    warning: warning
  }), (error || warning) && /*#__PURE__*/_react.default.createElement(_textbox.ErrorBorder, {
    inline: inline,
    warning: !!(!error && warning)
  }), /*#__PURE__*/_react.default.createElement(_radioButtonGroup.default, {
    "data-component": "radio-button-group",
    role: "radiogroup",
    inline: inline,
    legendInline: inlineLegend
  }, /*#__PURE__*/_react.default.createElement(_radioButtonMapper.default, {
    name: name,
    onBlur: onBlur,
    onChange: onChange,
    value: value
  }, _react.default.Children.map(children, child => {
    if (! /*#__PURE__*/_react.default.isValidElement(child)) {
      return child;
    }
    return /*#__PURE__*/_react.default.cloneElement(child, {
      inline,
      labelSpacing,
      error: !!error,
      warning: !!warning,
      info: !!info,
      required,
      ...child.props
    });
  }))))) : /*#__PURE__*/_react.default.createElement(_tooltipProvider.TooltipProvider, {
    tooltipPosition: tooltipPosition
  }, /*#__PURE__*/_react.default.createElement(_fieldset.default, _extends({
    legend: legend,
    error: error,
    warning: warning,
    info: info,
    inline: inlineLegend,
    legendWidth: legendWidth,
    legendAlign: legendAlign,
    legendSpacing: legendSpacing,
    isRequired: required,
    isOptional: isOptional
  }, (0, _tags.default)("radiogroup", props), marginProps, {
    ml: marginLeft,
    blockGroupBehaviour: !(error || warning || info)
  }), /*#__PURE__*/_react.default.createElement(_radioButtonGroup.default, {
    "data-component": "radio-button-group",
    role: "radiogroup",
    inline: inline,
    legendInline: inlineLegend
  }, /*#__PURE__*/_react.default.createElement(_radioButtonMapper.default, {
    name: name,
    onBlur: onBlur,
    onChange: onChange,
    value: value
  }, _react.default.Children.map(children, child => {
    if (! /*#__PURE__*/_react.default.isValidElement(child)) {
      return child;
    }
    return /*#__PURE__*/_react.default.cloneElement(child, {
      inline,
      labelSpacing,
      error: !!error,
      warning: !!warning,
      info: !!info,
      ...child.props
    });
  }))))));
};
exports.RadioButtonGroup = RadioButtonGroup;
RadioButtonGroup.displayName = "RadioButtonGroup";
var _default = exports.default = RadioButtonGroup;