"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StyledValuesLabel = exports.StyledValue = exports.StyledProgressTracker = exports.StyledProgressBar = exports.StyledDescription = exports.InnerBar = void 0;
var _styledComponents = _interopRequireWildcard(require("styled-components"));
var _styledSystem = require("styled-system");
var _base = _interopRequireDefault(require("../../style/themes/base"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function getHeight(size) {
  switch (size) {
    case "small":
      return "var(--sizing050)";
    case "large":
      return "var(--sizing200)";
    default:
      return "var(--sizing100)";
  }
}
function getBackgroundColour({
  progress,
  error
}) {
  if (error) return "var(--colorsSemanticNegative500)";
  if (progress && progress >= 100) return "var(--colorsSemanticPositive500)";
  return "var(--colorsSemanticNeutral500)";
}
function getBorderColour({
  progress,
  error
}) {
  if (error) return "var(--colorsSemanticNegative500)";
  if (progress === 100) return "var(--colorsSemanticPositive500)";
  return "var(--colorsSemanticNeutral500)";
}
const StyledProgressTracker = exports.StyledProgressTracker = _styledComponents.default.div`
  ${_styledSystem.margin}
  text-align: center;
  white-space: nowrap;

  ${({
  length
}) => (0, _styledComponents.css)`
      width: ${length};
    `};
  ${({
  labelsPosition
}) => labelsPosition === "left" && (0, _styledComponents.css)`
      display: flex;
      align-items: center;
    `}
`;
const StyledProgressBar = exports.StyledProgressBar = _styledComponents.default.span`
  ${({
  size,
  progress,
  error,
  theme
}) => (0, _styledComponents.css)`
    display: flex;
    position: relative;
    background-color: var(--colorsSemanticNeutral200);
    border: 1px solid ${getBorderColour({
  progress,
  error
})};
    border-radius: ${theme.roundedCornersOptOut ? "25px" : "var(--borderRadius400)"};
    overflow-x: hidden;
    height: ${getHeight(size)};
    width: 100%;
  `}
`;
const fontSizes = {
  small: "var(--fontSizes100)",
  medium: "var(--fontSizes100)",
  large: "var(--fontSizes200)"
};
const StyledValue = exports.StyledValue = _styledComponents.default.span`
  display: inline-block;
  font-weight: bold;
`;
const StyledDescription = exports.StyledDescription = _styledComponents.default.span`
  color: var(--colorsUtilityYin055);
  margin-left: 4px;
`;
const labelsPositionMargin = {
  top: "bottom",
  bottom: "top",
  left: "right"
};
const StyledValuesLabel = exports.StyledValuesLabel = _styledComponents.default.span`
  text-align: start;
  display: flex;
  justify-content: flex-start;
  gap: 4px;
  font-size: ${({
  size
}) => size && fontSizes[size]};

  ${({
  labelsPosition
}) => labelsPosition && `
      margin-${labelsPositionMargin[labelsPosition]}: var(--spacing100);
    `};

  ${({
  labelWidth
}) => labelWidth && (0, _styledComponents.css)`
      width: ${labelWidth};
      flex-shrink: 0;
    `};
`;
const InnerBar = exports.InnerBar = _styledComponents.default.span`
  ${({
  progress,
  size = "medium",
  length,
  error,
  theme
}) => (0, _styledComponents.css)`
    position: relative;
    left: 0;
    background-color: ${getBackgroundColour({
  progress,
  error
})};
    border-radius: ${theme.roundedCornersOptOut ? "25px" : "var(--borderRadius400)"};
    width: calc(${length} * ${progress && progress / 100});
    min-width: 2px;
    height: ${getHeight(size)};
  `}
`;
InnerBar.defaultProps = {
  theme: _base.default
};
StyledProgressBar.defaultProps = {
  theme: _base.default
};
StyledProgressTracker.defaultProps = {
  theme: _base.default
};