"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _useLocale = _interopRequireDefault(require("../../hooks/__internal__/useLocale"));
var _tags = _interopRequireDefault(require("../../__internal__/utils/helpers/tags"));
var _progressTracker = require("./progress-tracker.style");
var _useResizeObserver = _interopRequireDefault(require("../../hooks/__internal__/useResizeObserver"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
const ProgressTracker = ({
  "aria-label": ariaLabel = "progress tracker",
  "aria-describedby": ariaDescribedBy,
  "aria-valuenow": ariaValueNow,
  "aria-valuemin": ariaValueMin = 0,
  "aria-valuemax": ariaValueMax = 100,
  "aria-valuetext": ariaValueText,
  size = "medium",
  length = "256px",
  error = false,
  progress = 0,
  description,
  showDefaultLabels = false,
  currentProgressLabel,
  customValuePreposition,
  maxProgressLabel,
  labelsPosition = "top",
  labelWidth,
  ...rest
}) => {
  const l = (0, _useLocale.default)();
  const barRef = (0, _react.useRef)(null);
  const [barLength, setBarLength] = (0, _react.useState)("0px");
  const prefixLabels = labelsPosition !== "bottom";
  const updateBarLength = (0, _react.useCallback)(() => {
    setBarLength(`${barRef.current?.offsetWidth}px`);
  }, []);
  (0, _react.useLayoutEffect)(() => {
    updateBarLength();
  }, [updateBarLength]);
  (0, _useResizeObserver.default)(barRef, () => {
    updateBarLength();
  });
  const renderValueLabels = () => {
    if (!showDefaultLabels && !currentProgressLabel) {
      return null;
    }
    const label = (value, defaultValue) => {
      if (value) {
        return value;
      }
      return showDefaultLabels ? defaultValue : undefined;
    };
    const displayedCurrentProgressLabel = label(currentProgressLabel, `${progress}%`);
    const displayedMaxProgressLabel = label(maxProgressLabel, "100%");
    return /*#__PURE__*/_react.default.createElement(_progressTracker.StyledValuesLabel, {
      labelsPosition: labelsPosition,
      size: size,
      labelWidth: labelWidth
    }, displayedCurrentProgressLabel && /*#__PURE__*/_react.default.createElement(_progressTracker.StyledValue, {
      "data-element": "current-progress-label"
    }, displayedCurrentProgressLabel), displayedMaxProgressLabel && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("span", {
      "data-element": "custom-preposition"
    }, customValuePreposition || l.progressTracker.of()), /*#__PURE__*/_react.default.createElement(_progressTracker.StyledValue, {
      "data-element": "max-progress-label"
    }, displayedMaxProgressLabel)), description && /*#__PURE__*/_react.default.createElement(_progressTracker.StyledDescription, {
      "data-element": "progress-tracker-description"
    }, description));
  };
  const defaultValueNow = ariaValueMin + (ariaValueMax - ariaValueMin) * progress / 100;
  return /*#__PURE__*/_react.default.createElement(_progressTracker.StyledProgressTracker, _extends({
    length: length
  }, rest, (0, _tags.default)("progress-bar", rest), {
    role: "progressbar",
    "aria-label": ariaLabel,
    "aria-describedby": ariaDescribedBy,
    "aria-valuenow": ariaValueNow === undefined ? defaultValueNow : ariaValueNow,
    "aria-valuemin": ariaValueMin,
    "aria-valuemax": ariaValueMax,
    "aria-valuetext": ariaValueText,
    labelsPosition: labelsPosition
  }), prefixLabels && renderValueLabels(), /*#__PURE__*/_react.default.createElement(_progressTracker.StyledProgressBar, {
    size: size,
    ref: barRef,
    progress: progress,
    error: error
  }, /*#__PURE__*/_react.default.createElement(_progressTracker.InnerBar, {
    "data-element": "inner-bar",
    size: size,
    length: barLength,
    progress: progress,
    error: error
  })), !prefixLabels && renderValueLabels());
};
ProgressTracker.displayName = "ProgressTracker";
var _default = exports.default = ProgressTracker;