import React from "react";
import { MarginProps } from "styled-system";
export interface ProgressTrackerProps extends MarginProps {
    /** Specifies an aria label to the component */
    "aria-label"?: string;
    /** Specifies the aria describedby for the component */
    "aria-describedby"?: string;
    /** The value of progress to be read out to the user. */
    "aria-valuenow"?: number;
    /** The minimum value of the progress tracker */
    "aria-valuemin"?: number;
    /** The maximum value of the progress tracker */
    "aria-valuemax"?: number;
    /** Prop to define the human readable text alternative of aria-valuenow
     * if aria-valuenow is not a number
     */
    "aria-valuetext"?: string;
    /** Size of the progress bar. */
    size?: "small" | "medium" | "large";
    /** Length of the component, any valid css string. */
    length?: string;
    /** Current progress (percentage). */
    progress?: number;
    /** If error occurs. */
    error?: boolean;
    /** Flag to control whether the default value labels (as percentages) should be rendered. */
    description?: string;
    /** Value to add a description to the label */
    showDefaultLabels?: boolean;
    /** Value to display as current progress. */
    currentProgressLabel?: string;
    /** Value to display as the maximum progress limit. */
    maxProgressLabel?: string;
    /** Value of the preposition defined between Value1 and Value2 on the label. */
    customValuePreposition?: string;
    /**
     * The position the value label are rendered in.
     * Top/bottom apply to horizontal and left applies to vertical orientation.
     */
    labelsPosition?: "top" | "bottom" | "left";
    /** Label width */
    labelWidth?: string;
}
declare const ProgressTracker: {
    ({ "aria-label": ariaLabel, "aria-describedby": ariaDescribedBy, "aria-valuenow": ariaValueNow, "aria-valuemin": ariaValueMin, "aria-valuemax": ariaValueMax, "aria-valuetext": ariaValueText, size, length, error, progress, description, showDefaultLabels, currentProgressLabel, customValuePreposition, maxProgressLabel, labelsPosition, labelWidth, ...rest }: ProgressTrackerProps): React.JSX.Element;
    displayName: string;
};
export default ProgressTracker;
