"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ProfileTextStyle = exports.ProfileStyle = exports.ProfileNameStyle = exports.ProfileEmailStyle = exports.ProfileDetailsStyle = exports.ProfileAvatarStyle = void 0;
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _styledSystem = require("styled-system");
var _portrait = _interopRequireDefault(require("../portrait"));
var _base = _interopRequireDefault(require("../../style/themes/base"));
var _profile = _interopRequireDefault(require("./profile.config"));
var _link = _interopRequireDefault(require("../link"));
var _portrait2 = require("../portrait/portrait.style");
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
const ProfileNameStyle = exports.ProfileNameStyle = _styledComponents.default.span`
  font-weight: bold;
  font-size: ${({
  size = "M"
}) => _profile.default[size].nameSize};
`;
const ProfileEmailStyle = exports.ProfileEmailStyle = (0, _styledComponents.default)(_link.default)`
  a {
    font-size: ${({
  size = "M"
}) => _profile.default[size].emailSize};
    color: ${({
  darkBackground
}) => darkBackground && "var(--colorsActionMajor350)"};
  }
`;
const ProfileTextStyle = exports.ProfileTextStyle = _styledComponents.default.span`
  font-size: ${({
  size = "M"
}) => _profile.default[size].emailSize};
`;
const ProfileStyle = exports.ProfileStyle = _styledComponents.default.div`
  border-radius: inherit;
  white-space: nowrap;
  color: ${({
  darkBackground
}) => darkBackground ? "var(--colorsUtilityReadOnly600)" : "var(--colorsUtilityYin090)"};
  background-color: ${({
  darkBackground
}) => darkBackground ? "var(--colorsUtilityYin090)" : "transparent"};
  display: flex;
  flex-direction: row;
  ${_styledSystem.margin}

  ${_portrait2.StyledPortraitContainer} {
    flex-shrink: 0;
  }
`;
const ProfileDetailsStyle = exports.ProfileDetailsStyle = _styledComponents.default.div`
  vertical-align: middle;
  display: flex;
  flex-direction: column;
  justify-content: center;
  line-height: ${({
  size = "M"
}) => _profile.default[size].lineHeight};
  margin-left: ${({
  size = "M"
}) => _profile.default[size].marginLeft};
`;
const ProfileAvatarStyle = exports.ProfileAvatarStyle = (0, _styledComponents.default)(_portrait.default)`
  display: inline-block;
`;
ProfileStyle.defaultProps = {
  theme: _base.default
};