"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.Profile = void 0;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _tags = _interopRequireDefault(require("../../__internal__/utils/helpers/tags/tags"));
var _profile = require("./profile.style");
var _utils = require("../../style/utils");
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
function acronymize(str) {
  if (!str) return "";
  const matches = str.match(/\b\w/g);
  if (!matches) return "";
  return matches.join("");
}
let useOfNoNameWarnTriggered = false;
const Profile = ({
  src,
  alt,
  className,
  initials,
  name,
  size,
  email,
  text,
  darkBackground,
  ...props
}) => {
  const getInitials = () => {
    if (initials) return initials;
    return acronymize(name).slice(0, 3).toUpperCase();
  };
  const commonAvatarProps = {
    darkBackground,
    alt,
    name,
    initials: getInitials(),
    size
  };
  const avatar = () => {
    if (src) {
      return /*#__PURE__*/_react.default.createElement(_profile.ProfileAvatarStyle, _extends({
        src: src,
        "data-element": "user-image"
      }, commonAvatarProps));
    }
    return /*#__PURE__*/_react.default.createElement(_profile.ProfileAvatarStyle, _extends({
      gravatar: email
    }, commonAvatarProps));
  };
  if (!useOfNoNameWarnTriggered && !name && (email || text)) {
    useOfNoNameWarnTriggered = true;
    console.warn("[WARNING] The `email` or `text` prop should not be used without the `name` prop in `Profile`." + " Please use the `name` prop as well as `email` or `text`.");
  }
  const children = () => {
    if (name) return /*#__PURE__*/_react.default.createElement(_profile.ProfileDetailsStyle, {
      size: size,
      hasSrc: !!src,
      "data-element": "details"
    }, /*#__PURE__*/_react.default.createElement(_profile.ProfileNameStyle, {
      size: size,
      "data-element": "name"
    }, name), /*#__PURE__*/_react.default.createElement(_profile.ProfileEmailStyle, {
      href: `mailto: ${email}`,
      size: size,
      darkBackground: darkBackground,
      "data-element": "email"
    }, email), /*#__PURE__*/_react.default.createElement(_profile.ProfileTextStyle, {
      size: size,
      "data-element": "text"
    }, text));
    return null;
  };
  return /*#__PURE__*/_react.default.createElement(_profile.ProfileStyle, _extends({
    className: className,
    hasSrc: !!src,
    darkBackground: darkBackground
  }, (0, _tags.default)("profile", props), (0, _utils.filterStyledSystemMarginProps)(props)), avatar(), children());
};
exports.Profile = Profile;
var _default = exports.default = Profile;