"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.Preview = void 0;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _previewPlaceholder = _interopRequireDefault(require("./__internal__/preview-placeholder.component"));
var _preview = require("./preview.style");
var _utils = require("../../style/utils");
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
const Preview = ({
  children,
  loading,
  lines = 1,
  ...props
}) => {
  const marginProps = (0, _utils.filterStyledSystemMarginProps)(props);
  const hasPlaceholder = loading === undefined ? !children : loading;
  if (hasPlaceholder) {
    const placeholders = [];
    for (let i = 1; i <= lines; i++) {
      placeholders.push( /*#__PURE__*/_react.default.createElement(_previewPlaceholder.default, _extends({
        key: i,
        index: i,
        lines: lines
      }, props)));
    }
    return /*#__PURE__*/_react.default.createElement(_preview.StyledPreview, marginProps, placeholders);
  }
  return /*#__PURE__*/_react.default.createElement(_preview.StyledPreview, marginProps, children);
};
exports.Preview = Preview;
var _default = exports.default = Preview;