"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StyledPortraitInitials = exports.StyledPortraitGravatar = exports.StyledPortraitContainer = exports.StyledIcon = exports.StyledCustomImg = void 0;
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _styledSystem = require("styled-system");
var _base = _interopRequireDefault(require("../../style/themes/base"));
var _icon = _interopRequireDefault(require("../icon"));
var _portrait = require("./portrait.config");
var _profile = _interopRequireDefault(require("../profile/profile.config"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
const StyledPortraitInitials = exports.StyledPortraitInitials = _styledComponents.default.div`
  font-weight: bold;
  font-size: ${({
  size
}) => _profile.default[size].initialSize};
  display: flex;
  white-space: nowrap;
  align-items: center;
  justify-content: center;
  height: inherit;
  width: inherit;
`;
const StyledPortraitGravatar = exports.StyledPortraitGravatar = _styledComponents.default.img`
  height: inherit;
  width: inherit;
`;
const StyledCustomImg = exports.StyledCustomImg = _styledComponents.default.img`
  height: inherit;
  width: inherit;
`;

// && is used here to increase the specificity
// eslint-disable-next-line @typescript-eslint/no-unused-vars
const StyledIcon = exports.StyledIcon = (0, _styledComponents.default)(_icon.default)`
  && {
    color: inherit;
    height: inherit;
    width: inherit;

    ::before {
      font-size: ${({
  size
}) => _portrait.PORTRAIT_SIZE_PARAMS[size].iconDimensions}px;
    }
  }
`;
const StyledPortraitContainer = exports.StyledPortraitContainer = _styledComponents.default.div`
  color: ${({
  darkBackground
}) => darkBackground ? "var(--colorsUtilityReadOnly600)" : "var(--colorsUtilityYin090)"};
  background-color: ${({
  darkBackground
}) => darkBackground ? "var(--colorsUtilityYin090)" : "var(--colorsUtilityReadOnly400)"};
  width: ${({
  size
}) => _portrait.PORTRAIT_SIZE_PARAMS[size].dimensions}px;
  height: ${({
  size
}) => _portrait.PORTRAIT_SIZE_PARAMS[size].dimensions}px;
  overflow: hidden;
  border-radius: ${({
  shape
}) => shape === "square" ? "0px" : "var(--borderRadiusCircle)"};
  border: 1px solid var(--colorsUtilityReadOnly600);
  display: inline-block;
  ${({
  onClick
}) => onClick && "cursor: pointer"}
  ${_styledSystem.margin}
`;
StyledPortraitContainer.defaultProps = {
  theme: _base.default
};