"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _md = _interopRequireDefault(require("crypto-js/md5"));
var _invariant = _interopRequireDefault(require("invariant"));
var _tooltip = _interopRequireDefault(require("../tooltip"));
var _tags = _interopRequireDefault(require("../../__internal__/utils/helpers/tags/tags"));
var _portrait = require("./portrait.config");
var _portrait2 = require("./portrait.style");
var _utils = require("../../style/utils");
var _carbonProvider = require("../carbon-provider/carbon-provider.component");
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
const Portrait = ({
  alt,
  name,
  darkBackground = false,
  gravatar = "",
  iconType = "individual",
  initials,
  shape,
  size = "M",
  src,
  onClick,
  tooltipMessage,
  tooltipId,
  tooltipIsVisible,
  tooltipPosition,
  tooltipType,
  tooltipSize,
  tooltipBgColor,
  tooltipFontColor,
  ...rest
}) => {
  const [externalError, setExternalError] = (0, _react.useState)(false);
  const {
    roundedCornersOptOut
  } = (0, _react.useContext)(_carbonProvider.NewValidationContext);
  const defaultShape = roundedCornersOptOut ? "square" : "circle";
  !!(src && gravatar) ? process.env.NODE_ENV !== "production" ? (0, _invariant.default)(false, "The `src` prop cannot be used in conjunction with the `gravatar` prop." + " Please use one or the other.") : (0, _invariant.default)(false) : void 0;
  (0, _react.useEffect)(() => {
    setExternalError(false);
  }, [gravatar, src]);
  const tagProps = (0, _tags.default)("portrait", rest);
  const gravatarSrc = () => {
    const {
      dimensions
    } = _portrait.PORTRAIT_SIZE_PARAMS[size];
    const base = "https://www.gravatar.com/avatar/";
    const hash = (0, _md.default)(gravatar.toLowerCase());
    const fallbackOption = "404"; // "Return an HTTP 404 File Not Found response"

    /** @see https://en.gravatar.com/site/implement/images/#default-image */
    return `${base}${hash}?s=${dimensions}&d=${fallbackOption}`;
  };
  const renderComponent = () => {
    let portrait = /*#__PURE__*/_react.default.createElement(_portrait2.StyledIcon, {
      type: iconType,
      size: size
    });
    if (initials) {
      portrait = /*#__PURE__*/_react.default.createElement(_portrait2.StyledPortraitInitials, {
        size: size,
        "data-element": "initials"
      }, initials.slice(0, 3).toUpperCase());
    }
    if (src && !externalError) {
      portrait = /*#__PURE__*/_react.default.createElement(_portrait2.StyledCustomImg, {
        src: src,
        alt: alt || name || "",
        "data-element": "user-image",
        onError: () => setExternalError(true)
      });
    }
    if (gravatar && !externalError) {
      portrait = /*#__PURE__*/_react.default.createElement(_portrait2.StyledPortraitGravatar, {
        src: gravatarSrc(),
        alt: alt || name || "",
        onError: () => setExternalError(true)
      });
    }
    if (tooltipMessage) {
      return /*#__PURE__*/_react.default.createElement(_tooltip.default, {
        message: tooltipMessage,
        id: tooltipId,
        position: tooltipPosition,
        type: tooltipType,
        size: tooltipSize,
        isVisible: tooltipIsVisible,
        bgColor: tooltipBgColor,
        fontColor: tooltipFontColor
      }, /*#__PURE__*/_react.default.createElement(_portrait2.StyledPortraitContainer, _extends({}, (0, _utils.filterStyledSystemMarginProps)(rest), {
        onClick: onClick
      }, tagProps, {
        darkBackground: darkBackground,
        size: size,
        shape: shape || defaultShape
      }), portrait));
    }
    return /*#__PURE__*/_react.default.createElement(_portrait2.StyledPortraitContainer, _extends({}, (0, _utils.filterStyledSystemMarginProps)(rest), {
      onClick: onClick
    }, tagProps, {
      darkBackground: darkBackground,
      size: size,
      shape: shape || defaultShape
    }), portrait);
  };
  return renderComponent();
};
var _default = exports.default = Portrait;