import React from "react";
import { MarginProps } from "styled-system";
import { IconType } from "../icon";
export declare type PortraitShapes = "circle" | "square";
export declare type PortraitSizes = "XS" | "S" | "M" | "ML" | "L" | "XL" | "XXL";
export interface PortraitProps extends MarginProps {
    /** An email address registered with Gravatar. */
    gravatar?: string;
    /** A custom image URL. */
    src?: string;
    /** The size of the Portrait. */
    size?: PortraitSizes;
    /** @private @ignore */
    name?: string;
    /** The `alt` HTML string. */
    alt?: string;
    /** The shape of the Portrait. */
    shape?: PortraitShapes;
    /** Icon to be rendered as a fallback. */
    iconType?: IconType;
    /** The initials to render in the Portrait. */
    initials?: string;
    /** Use a dark background. */
    darkBackground?: boolean;
    /** Prop for `onClick` events. */
    onClick?: (ev: React.MouseEvent<HTMLElement>) => void;
    /** The message to be displayed within the tooltip */
    tooltipMessage?: React.ReactNode;
    /** The id attribute to use for the tooltip */
    tooltipId?: string;
    /** Whether to to show the Tooltip */
    tooltipIsVisible?: boolean;
    /** Sets position of the tooltip */
    tooltipPosition?: "top" | "bottom" | "left" | "right";
    /** Defines the message type */
    tooltipType?: string;
    /** Defines the size of the tooltip content */
    tooltipSize?: "medium" | "large";
    /** Override background color of the Tooltip, provide any color from palette or any valid css color value. */
    tooltipBgColor?: string;
    /** Override font color of the Tooltip, provide any color from palette or any valid css color value. */
    tooltipFontColor?: string;
}
declare const Portrait: ({ alt, name, darkBackground, gravatar, iconType, initials, shape, size, src, onClick, tooltipMessage, tooltipId, tooltipIsVisible, tooltipPosition, tooltipType, tooltipSize, tooltipBgColor, tooltipFontColor, ...rest }: PortraitProps) => React.JSX.Element;
export default Portrait;
