"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.PortalContext = exports.Portal = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactDom = _interopRequireDefault(require("react-dom"));
var _styledComponents = _interopRequireWildcard(require("styled-components"));
var _guid = _interopRequireDefault(require("../../__internal__/utils/helpers/guid"));
var _carbonScopedTokensProvider = _interopRequireDefault(require("../../style/design-tokens/carbon-scoped-tokens-provider/carbon-scoped-tokens-provider.component"));
var _portal = _interopRequireDefault(require("./portal.style"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const PortalContext = exports.PortalContext = /*#__PURE__*/_react.default.createContext({});
const Container = _styledComponents.default.div`
  ${({
  theme
}) => (0, _styledComponents.css)`
     {
      position: relative;
      z-index: ${theme.zIndex.aboveAll};
    }
  `}
`;
const Portal = ({
  children,
  className,
  id,
  onReposition,
  inertOptOut
}) => {
  const [portalNode, setPortalNode] = (0, _react.useState)(null);
  const uniqueId = (0, _react.useMemo)(() => (0, _guid.default)(), []);
  const {
    renderInRoot
  } = (0, _react.useContext)(PortalContext);
  (0, _react.useEffect)(() => {
    if (onReposition) {
      onReposition();
      window.addEventListener("resize", onReposition);
    }
    return () => {
      if (onReposition) {
        window.removeEventListener("resize", onReposition);
      }
    };
  }, [onReposition]);
  (0, _react.useEffect)(() => {
    return () => {
      portalNode?.remove();
    };
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  const addClassNames = node => {
    className?.split(" ").forEach(el => {
      node?.classList.add(el);
    });
    return node;
  };
  const getPortalContainer = () => {
    const portalClassName = "carbon-portal";
    let node = portalNode;
    if (!node && id !== undefined && document.getElementById(id)) {
      node = document.getElementById(id);
      setPortalNode(node);
    } else if (!node || document.getElementsByClassName(portalClassName).length === 0) {
      node = document.createElement("div");
      node.classList.add(portalClassName);
      node.setAttribute("data-portal-exit", uniqueId);
      if (id !== undefined) {
        node.setAttribute("id", id);
      }
      if (inertOptOut) {
        node.setAttribute("data-not-inert", "true");
      }
      setPortalNode(node);
      let mainNode = document.body;
      const rootDiv = document.getElementById("root");
      if (rootDiv && renderInRoot) {
        mainNode = rootDiv;
      }
      mainNode.appendChild(node);
    }
    if (className) {
      node = addClassNames(node);
    }
    return node;
  };
  const portalContent = inertOptOut ? /*#__PURE__*/_react.default.createElement(Container, null, children) : children;
  return /*#__PURE__*/_react.default.createElement(_portal.default, {
    "data-portal-entrance": uniqueId
  }, /*#__PURE__*/_reactDom.default.createPortal( /*#__PURE__*/_react.default.createElement(_carbonScopedTokensProvider.default, null, portalContent), getPortalContainer()));
};
exports.Portal = Portal;
var _default = exports.default = Portal;