import React from "react";
interface PortalContextProps {
    renderInRoot?: boolean;
}
export declare const PortalContext: React.Context<PortalContextProps>;
export interface PortalProps {
    /** The content of the portal. */
    children?: React.ReactNode;
    /** Classname attached to portal container. */
    className?: string;
    /** Id attribute attached to portal container. */
    id?: string;
    /** Callback function triggered when parent element is scrolled or window resized. */
    onReposition?: () => void;
    /** A flag to ensure the portal content will remain interactive with by both mouse
     * users and screenreader users, even if a modal is opened outside of or on top of
     * the portal.
     * To be used with caution.
     */
    inertOptOut?: boolean;
}
export declare const Portal: ({ children, className, id, onReposition, inertOptOut, }: PortalProps) => React.JSX.Element;
export default Portal;
