"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PopoverContainerWrapperStyle = exports.PopoverContainerTitleStyle = exports.PopoverContainerOpenIcon = exports.PopoverContainerHeaderStyle = exports.PopoverContainerContentStyle = exports.PopoverContainerCloseIcon = void 0;
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _styledSystem = require("styled-system");
var _themes = require("../../style/themes");
var _iconButton = _interopRequireDefault(require("../icon-button"));
var _icon = _interopRequireDefault(require("../icon/icon.style"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function animationToRender({
  animationState,
  disableAnimation
}) {
  if (disableAnimation) return "opacity: 1;";
  switch (animationState) {
    case "entering":
      return `
        opacity: 0;
        transform: translateY(-8px);
      `;
    case "entered":
      return `
        opacity: 1; 
        transform: translateY(0);
        transition: all 0.3s cubic-bezier(0.25, 0.25, 0, 1.5);
      `;
    case "exiting":
      return `
        opacity: 0; 
        transform: translateY(-8px);
        transition: all 0.3s cubic-bezier(0.25, 0.25, 0, 1.5);
      `;
    default:
      return "opacity: 0;";
  }
}
const PopoverContainerWrapperStyle = exports.PopoverContainerWrapperStyle = _styledComponents.default.div`
  position: relative;
  display: inline-block;
  width: 100%;
`;
const PopoverContainerHeaderStyle = exports.PopoverContainerHeaderStyle = _styledComponents.default.div`
  display: flex;
  justify-content: space-between;
  margin-bottom: 8px;
  max-width: 280px;
`;
const PopoverContainerContentStyle = exports.PopoverContainerContentStyle = _styledComponents.default.div`
  ${_styledSystem.padding}

  background: var(--colorsUtilityYang100);
  border-radius: var(--borderRadius100);
  box-shadow: var(--boxShadow100);
  min-width: 300px;
  position: absolute;
  z-index: ${({
  theme
}) => theme.zIndex.popover};

  ${animationToRender}

  :focus {
    outline: none;
  }
`;
const PopoverContainerOpenIcon = exports.PopoverContainerOpenIcon = (0, _styledComponents.default)(_iconButton.default)`
  ${_icon.default} {
    color: var(--colorsActionMinor500);
  }
`;
const PopoverContainerCloseIcon = exports.PopoverContainerCloseIcon = (0, _styledComponents.default)(_iconButton.default)`
  position: absolute;
  top: 16px;
  right: 24px;

  ${_icon.default} {
    color: var(--colorsActionMinor500);
  }
`;
const PopoverContainerTitleStyle = exports.PopoverContainerTitleStyle = _styledComponents.default.div`
  font-size: 16px;
  font-weight: bold;
`;
PopoverContainerContentStyle.defaultProps = {
  theme: _themes.baseTheme
};