"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.renderOpen = exports.renderClose = exports.default = exports.PopoverContainer = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _reactTransitionGroup = require("react-transition-group");
var _dom = require("@floating-ui/dom");
var _useMediaQuery = _interopRequireDefault(require("../../hooks/useMediaQuery"));
var _popoverContainer = require("./popover-container.style");
var _icon = _interopRequireDefault(require("../icon"));
var _popover = _interopRequireDefault(require("../../__internal__/popover"));
var _guid = _interopRequireDefault(require("../../__internal__/utils/helpers/guid"));
var _utils = require("../../style/utils");
var _useClickAwayListener = _interopRequireDefault(require("../../hooks/__internal__/useClickAwayListener"));
var _events = _interopRequireDefault(require("../../__internal__/utils/helpers/events"));
var _focusTrap = _interopRequireDefault(require("../../__internal__/focus-trap"));
var _modal = require("../modal");
var _useFocusPortalContent = _interopRequireDefault(require("../../hooks/__internal__/useFocusPortalContent"));
var _tags = _interopRequireDefault(require("../../__internal__/utils/helpers/tags/tags"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
const renderOpen = ({
  tabIndex,
  onClick,
  "data-element": dataElement,
  ref,
  "aria-label": ariaLabel,
  id,
  "aria-expanded": ariaExpanded,
  "aria-haspopup": ariaHasPopup
}) => {
  return /*#__PURE__*/_react.default.createElement(_popoverContainer.PopoverContainerOpenIcon, {
    tabIndex: tabIndex,
    onClick: onClick,
    "data-element": dataElement,
    ref: ref,
    "aria-label": ariaLabel,
    "aria-haspopup": ariaHasPopup,
    "aria-expanded": ariaExpanded,
    id: id
  }, /*#__PURE__*/_react.default.createElement(_icon.default, {
    type: "settings"
  }));
};
exports.renderOpen = renderOpen;
const renderClose = ({
  "data-element": dataElement,
  tabIndex,
  onClick,
  ref,
  "aria-label": ariaLabel,
  closeButtonDataProps
}) => /*#__PURE__*/_react.default.createElement(_popoverContainer.PopoverContainerCloseIcon, _extends({
  tabIndex: tabIndex,
  onClick: onClick,
  ref: ref,
  "aria-label": ariaLabel
}, (0, _tags.default)("close", {
  "data-element": dataElement,
  ...closeButtonDataProps
})), /*#__PURE__*/_react.default.createElement(_icon.default, {
  type: "close"
}));
exports.renderClose = renderClose;
function getPopoverMiddleware(shouldCoverButton) {
  return [(0, _dom.offset)(shouldCoverButton ? ({
    rects
  }) => ({
    mainAxis: -rects.reference.height
  }) : 6), (0, _dom.flip)({
    fallbackStrategy: "initialPlacement"
  })];
}
const PopoverContainer = ({
  children,
  title,
  position = "right",
  open,
  onOpen,
  onClose,
  renderOpenComponent = renderOpen,
  renderCloseComponent = renderClose,
  shouldCoverButton = false,
  ariaDescribedBy,
  openButtonAriaLabel,
  closeButtonAriaLabel = "close",
  containerAriaLabel,
  closeButtonDataProps,
  disableAnimation = false,
  ...rest
}) => {
  const isControlled = open !== undefined;
  const [isOpenInternal, setIsOpenInternal] = (0, _react.useState)(false);
  const closeButtonRef = (0, _react.useRef)(null);
  const openButtonRef = (0, _react.useRef)(null);
  const popoverReference = (0, _react.useRef)(null);
  const guid = (0, _react.useRef)((0, _guid.default)());
  const popoverContentNodeRef = (0, _react.useRef)(null);
  const popoverContainerId = title ? `PopoverContainer_${guid.current}` : undefined;
  const isOpen = isControlled ? open : isOpenInternal;
  const reduceMotion = !(0, _useMediaQuery.default)("screen and (prefers-reduced-motion: no-preference)");
  const closePopover = (0, _react.useCallback)(ev => {
    if (!isControlled) {
      setIsOpenInternal(false);
    }
    if (onClose) {
      onClose(ev);
    }
    if (isOpen && openButtonRef.current) {
      openButtonRef.current.focus();
    }
  }, [isControlled, isOpen, onClose]);
  const handleEscKey = (0, _react.useCallback)(ev => {
    const eventIsFromSelectInput = _events.default.composedPath(ev).find(element => {
      return element instanceof HTMLElement && element.getAttribute("data-element") === "input" && element.getAttribute("aria-expanded") === "true";
    });
    if (!eventIsFromSelectInput && _events.default.isEscKey(ev)) {
      closePopover(ev);
    }
  }, [closePopover]);
  (0, _react.useEffect)(() => {
    document.addEventListener("keydown", handleEscKey);
    return () => {
      document.removeEventListener("keydown", handleEscKey);
    };
  }, [handleEscKey]);
  const handleOpenButtonClick = e => {
    if (!isControlled) setIsOpenInternal(!isOpen);

    // We want the open button to close the popover if it is already open
    if (!isOpen) {
      if (onOpen) onOpen(e);
    } else if (onClose) onClose(e);
  };
  const handleCloseButtonClick = e => {
    closePopover(e);
  };
  (0, _useFocusPortalContent.default)(shouldCoverButton ? undefined : popoverContentNodeRef, shouldCoverButton ? undefined : openButtonRef, closePopover);
  const renderOpenComponentProps = {
    tabIndex: 0,
    "aria-expanded": isOpen,
    "aria-haspopup": "dialog",
    isOpen,
    "data-element": "popover-container-open-component",
    onClick: handleOpenButtonClick,
    ref: openButtonRef,
    "aria-label": openButtonAriaLabel || title,
    id: isOpen ? undefined : popoverContainerId
  };
  const renderCloseComponentProps = {
    "data-element": "popover-container-close-component",
    tabIndex: 0,
    onClick: handleCloseButtonClick,
    ref: closeButtonRef,
    "aria-label": closeButtonAriaLabel,
    closeButtonDataProps
  };
  const handleClickAway = e => {
    if (!isControlled) setIsOpenInternal(false);
    if (onClose && isOpen) onClose(e);
  };
  const handleClick = (0, _useClickAwayListener.default)(handleClickAway, "mousedown");
  const [isAnimationComplete, setIsAnimationComplete] = (0, _react.useState)(false);
  const popover = state => /*#__PURE__*/_react.default.createElement(_popoverContainer.PopoverContainerContentStyle, _extends({
    "data-element": "popover-container-content",
    role: "dialog",
    animationState: state,
    "aria-labelledby": popoverContainerId,
    "aria-label": containerAriaLabel,
    "aria-describedby": ariaDescribedBy,
    p: "16px 24px",
    ref: popoverContentNodeRef,
    tabIndex: shouldCoverButton ? -1 : undefined,
    disableAnimation: disableAnimation || reduceMotion
  }, (0, _utils.filterStyledSystemPaddingProps)(rest)), /*#__PURE__*/_react.default.createElement(_popoverContainer.PopoverContainerHeaderStyle, null, /*#__PURE__*/_react.default.createElement(_popoverContainer.PopoverContainerTitleStyle, {
    id: popoverContainerId,
    "data-element": "popover-container-title"
  }, title), renderCloseComponent(renderCloseComponentProps)), children);
  const childrenToRender = state => shouldCoverButton ? /*#__PURE__*/_react.default.createElement(_modal.ModalContext.Provider, {
    value: {
      isAnimationComplete
    }
  }, /*#__PURE__*/_react.default.createElement(_focusTrap.default, {
    wrapperRef: popoverContentNodeRef,
    isOpen: isOpen
  }, popover(state))) : popover(state);
  return /*#__PURE__*/_react.default.createElement(_popoverContainer.PopoverContainerWrapperStyle, {
    "data-component": "popover-container",
    onMouseDown: handleClick
  }, /*#__PURE__*/_react.default.createElement("div", {
    ref: popoverReference
  }, renderOpenComponent(renderOpenComponentProps)), /*#__PURE__*/_react.default.createElement(_reactTransitionGroup.Transition, {
    in: isOpen,
    timeout: {
      exit: 300
    },
    appear: true,
    mountOnEnter: true,
    unmountOnExit: true,
    nodeRef: popoverContentNodeRef,
    onEntered: shouldCoverButton ? /* istanbul ignore next */() => setIsAnimationComplete(true) : undefined,
    onExiting: shouldCoverButton ? /* istanbul ignore next */() => setIsAnimationComplete(false) : undefined
  }, state => isOpen && /*#__PURE__*/_react.default.createElement(_popover.default, {
    reference: popoverReference,
    placement: position === "right" ? "bottom-start" : "bottom-end",
    popoverStrategy: disableAnimation || reduceMotion ? "fixed" : "absolute",
    middleware: getPopoverMiddleware(shouldCoverButton),
    childRefOverride: popoverContentNodeRef
  }, childrenToRender(state))));
};
exports.PopoverContainer = PopoverContainer;
var _default = exports.default = PopoverContainer;