"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StyledUndoButton = exports.StyledTitle = exports.StyledSubtitle = exports.StyledPod = exports.StyledHeader = exports.StyledFooter = exports.StyledEditAction = exports.StyledDeleteButton = exports.StyledContent = exports.StyledBlock = exports.StyledActionsContainer = void 0;
var _styledComponents = _interopRequireWildcard(require("styled-components"));
var _styledSystem = require("styled-system");
var _themes = require("../../style/themes");
var _link = require("../link/link.style");
var _iconButton = _interopRequireDefault(require("../icon-button"));
var _icon = _interopRequireDefault(require("../icon/icon.style"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const StyledPod = exports.StyledPod = _styledComponents.default.div`
  ${_styledSystem.margin}
  display: flex;
  align-items: flex-start;
  width: 100%;
  ${({
  internalEditButton
}) => internalEditButton && "position: relative"};
  ${({
  height
}) => height && `height: ${height}`};

  &:focus {
    outline: none;
  }
`;
const blockBackgrounds = {
  primary: "var(--colorsUtilityYang100)",
  secondary: "var(--colorsUtilityMajor025)",
  tertiary: "var(--colorsUtilityMajor040)",
  transparent: "var(--colorsUtilityMajorTransparent)",
  tile: "var(--colorsUtilityYang100)"
};
const StyledBlock = exports.StyledBlock = _styledComponents.default.div`
  ${({
  variant,
  softDelete,
  noBorder,
  hasButtons,
  contentTriggersEdit,
  fullWidth,
  internalEditButton,
  isHovered,
  isFocused
}) => (0, _styledComponents.css)`
      box-sizing: border-box;
      border-radius: var(--borderRadius100);
      display: flex;
      flex-direction: column;
      background-color: ${blockBackgrounds[variant]};
      width: 100%;
      height: 100%;

      ${variant === "tile" && "box-shadow: 0 2px 3px 0 rgba(2, 18, 36, 0.2)"};

      ${noBorder ? "border: none" : `border: 1px solid var(--colorsUtilityMajor100)`};

      ${hasButtons && !(fullWidth || internalEditButton) && "width: auto;"};

      ${contentTriggersEdit && "cursor: pointer"};

      ${(isHovered || isFocused) && (0, _styledComponents.css)`
        background-color: var(--colorsUtilityMajor075);

        ${internalEditButton && variant === "tile" && "background-color: var(--colorsUtilityMajorTransparent);"}

        ${contentTriggersEdit && (0, _styledComponents.css)`
          background-color: var(--colorsActionMajor600);
          * {
            color: var(--colorsUtilityYang100);
          }
        `}
      `}

      ${(!internalEditButton || contentTriggersEdit) && (isFocused ? (0, _styledComponents.css)`
            outline: 3px solid var(--colorsSemanticFocus500);
            border: none;
            padding: ${noBorder ? 0 : 1}px;
          ` : (0, _styledComponents.css)`
            outline: none;
          `)}

      ${softDelete && (0, _styledComponents.css)`
        border: none;
        background-color: var(--colorsActionDisabled500);

        & > * {
          color: var(--colorsUtilityYin065);
        }
      `};
    `}
`;
const contentPaddings = {
  "extra-small": "8px",
  small: "8px",
  medium: "16px",
  large: "32px 24px",
  "extra-large": "40px"
};
const StyledContent = exports.StyledContent = _styledComponents.default.div`
  text-align: left;
  padding: ${({
  size
}) => contentPaddings[size]};
  flex-grow: 1;
`;
const footerPaddings = {
  "extra-small": "8px",
  small: "8px",
  medium: "8px 16px",
  large: "16px 24px",
  "extra-large": "24px 40px"
};
const StyledFooter = exports.StyledFooter = _styledComponents.default.div`
  ${({
  variant,
  size,
  softDelete
}) => (0, _styledComponents.css)`
    background-color: var(--colorsUtilityMajor025);
    border-bottom-left-radius: var(--borderRadius100);
    border-bottom-right-radius: var(--borderRadius100);
    box-shadow: inset 0px 1px 1px 0 rgba(0, 0, 0, 0.1);
    color: var(--colorsUtilityYin090);
    padding: ${footerPaddings[size]};

    ${softDelete && `color: var(--colorsUtilityYin055)`};

    ${variant === "tile" && `border-top: 1px solid var(--colorsUtilityMajor100)`};
  `}
`;
const StyledActionsContainer = exports.StyledActionsContainer = _styledComponents.default.div`
  display: flex;
  flex-direction: column;

  ${({
  internalEditButton
}) => internalEditButton && (0, _styledComponents.css)`
      position: absolute;
      right: 2px;
      top: 2px;
      z-index: 10;
    `}
`;
const actionButtonSizes = {
  "extra-small": 34,
  small: 34,
  medium: 50,
  large: 50,
  "extra-large": 50
};
const actionButtonBackgrounds = {
  primary: "var(--colorsActionMajorYang100)",
  secondary: "var(--colorsActionMinor050)",
  tertiary: "var(--colorsActionMinor100)",
  transparent: "var(--colorsActionMajorTransparent)",
  tile: "var(--colorsActionMajorYang100)"
};
const StyledEditAction = exports.StyledEditAction = (0, _styledComponents.default)(_iconButton.default)`
  && {
    ${({
  displayOnlyOnHover,
  isHovered,
  isFocused,
  variant,
  size,
  internalEditButton,
  noBorder
}) => (0, _styledComponents.css)`
      cursor: pointer;
      background-color: ${actionButtonBackgrounds[variant]};
      border: 1px solid var(--colorsActionMinor200);
      margin-left: 8px;
      margin-bottom: 8px;
      box-sizing: border-box;
      height: ${`${actionButtonSizes[size]}px`};
      width: ${`${actionButtonSizes[size]}px`};
      display: flex;
      align-items: center;
      justify-content: center;
      border-radius: var(--borderRadius100);

      ${_icon.default} {
        top: -2px;
        height: 16px;
        width: 16px;
        color: var(--colorsActionMajor500);
      }

      ${displayOnlyOnHover && !(isHovered || isFocused) && "display: none"}

      ${noBorder && "border: none;"}

      ${internalEditButton && (0, _styledComponents.css)`
        border: none;
        background: var(--colorsActionMajorTransparent);
      `}
    
      ${(isHovered || isFocused) && !internalEditButton && (0, _styledComponents.css)`
        background-color: var(--colorsActionMajor600);
        color: var(--colorsActionMajorYang100);

        ${_icon.default} {
          color: var(--colorsActionMajorYang100);
        }
      `}
      
      ${isFocused && (0, _styledComponents.css)`
        outline: 3px solid var(--colorsSemanticFocus500);
        border: none;
      `};
    `};
  }

  ${_link.StyledContent} {
    clip: rect(1px, 1px, 1px, 1px);
    position: absolute;
  }
`;
const StyledDeleteButton = exports.StyledDeleteButton = (0, _styledComponents.default)(_iconButton.default)`
  && {
    ${({
  noBorder,
  internalEditButton,
  isHovered,
  isFocused,
  variant,
  size
}) => (0, _styledComponents.css)`
      cursor: pointer;
      background-color: ${actionButtonBackgrounds[variant]};
      border: ${noBorder ? "none" : "1px solid var(--colorsActionMinor200)"};
      margin-left: 8px;
      margin-bottom: 8px;
      box-sizing: border-box;
      height: ${`${actionButtonSizes[size]}px`};
      width: ${`${actionButtonSizes[size]}px`};
      border-radius: var(--borderRadius100);

      ${_icon.default} {
        top: -2px;
        height: 16px;
        width: 16px;
        color: var(--colorsSemanticNegative500);
      }

      ${internalEditButton && (0, _styledComponents.css)`
        border: none;
        background: var(--colorsActionMajorTransparent);
      `}

      ${(isHovered || isFocused) && !internalEditButton && (0, _styledComponents.css)`
        background-color: var(--colorsSemanticNegative600);
        color: var(--colorsActionMajorYang100);

        ${_icon.default} {
          color: var(--colorsActionMajorYang100);
        }
      `}
  
      ${isFocused && (0, _styledComponents.css)`
        outline: 3px solid var(--colorsSemanticFocus500);
        border: none;
      `};
    `}
  }
`;
const StyledUndoButton = exports.StyledUndoButton = (0, _styledComponents.default)(_iconButton.default)`
  && {
    ${({
  isHovered,
  isFocused,
  variant,
  size,
  noBorder,
  internalEditButton
}) => (0, _styledComponents.css)`
      cursor: pointer;
      background-color: ${actionButtonBackgrounds[variant]};
      border: 1px solid var(--colorsActionMinor200);
      margin-left: 8px;
      margin-bottom: 8px;
      box-sizing: border-box;
      height: ${`${actionButtonSizes[size]}px`};
      width: ${`${actionButtonSizes[size]}px`};
      border-radius: var(--borderRadius100);

      ${_icon.default} {
        top: -2px;
        height: 16px;
        width: 16px;
        color: var(--colorsActionMajor500);
      }

      ${noBorder && "border: none;"}

      ${internalEditButton && (0, _styledComponents.css)`
        border: none;
        background: var(--colorsActionMajorTransparent);
      `}
    
    ${(isHovered || isFocused) && !internalEditButton && (0, _styledComponents.css)`
        background-color: var(--colorsActionMajor600);
        color: var(--colorsActionMajorYang100);

        ${_icon.default} {
          color: var(--colorsActionMajorYang100);
        }
      `}
    
    ${isFocused && (0, _styledComponents.css)`
        outline: 3px solid var(--colorsSemanticFocus500);
        border: none;
      `};
    `}
  }
`;
const headerRightAlignMargins = {
  "extra-small": 20,
  small: 25,
  medium: 30,
  large: 30,
  "extra-large": 30
};
const StyledHeader = exports.StyledHeader = _styledComponents.default.div`
  ${({
  alignTitle,
  internalEditButton,
  size
}) => (0, _styledComponents.css)`
    margin-bottom: 24px;
    text-align: ${alignTitle};

    ${alignTitle === "right" && internalEditButton && (0, _styledComponents.css)`
      margin-right: ${headerRightAlignMargins[size]}px;
    `};
  `}
`;
const StyledSubtitle = exports.StyledSubtitle = _styledComponents.default.h5`
  margin-top: 8px;
  font-size: 14px;
  font-weight: normal;
`;
const StyledTitle = exports.StyledTitle = _styledComponents.default.h4`
  display: inline;
  font-size: 18px;
  font-weight: 600;
`;
StyledPod.defaultProps = {
  theme: _themes.baseTheme
};