/// <reference types="react" />
import { MarginProps } from "styled-system";
import { PodProps } from "./pod.component";
import { PodSize, PodVariant } from "./pod.config";
declare const StyledPod: import("styled-components").StyledComponent<"div", any, MarginProps<Required<import("styled-system").Theme<import("styled-system").TLengthStyledSystem>>> & Pick<PodProps, "height" | "alignTitle" | "internalEditButton">, never>;
interface StyledBlockProps extends Pick<PodProps, "softDelete" | "internalEditButton"> {
    variant: PodVariant;
    noBorder: boolean;
    hasButtons: boolean;
    contentTriggersEdit?: boolean;
    fullWidth?: boolean;
    isHovered?: boolean;
    isFocused?: boolean;
}
declare const StyledBlock: import("styled-components").StyledComponent<"div", any, StyledBlockProps, never>;
declare const StyledContent: import("styled-components").StyledComponent<"div", any, {
    size: PodSize;
}, never>;
interface StyledFooterProps extends Pick<PodProps, "softDelete"> {
    variant: PodVariant;
    size: PodSize;
}
declare const StyledFooter: import("styled-components").StyledComponent<"div", any, StyledFooterProps, never>;
declare const StyledActionsContainer: import("styled-components").StyledComponent<"div", any, Pick<PodProps, "internalEditButton">, never>;
interface CommonPodButtonProps extends Pick<PodProps, "internalEditButton"> {
    isHovered?: boolean;
    isFocused?: boolean;
    size: PodSize;
    noBorder: boolean;
    variant: PodVariant;
}
interface StyledEditActionProps extends CommonPodButtonProps {
    displayOnlyOnHover?: boolean;
}
declare const StyledEditAction: import("styled-components").StyledComponent<import("react").ForwardRefExoticComponent<import("../icon-button").IconButtonProps & import("react").RefAttributes<HTMLButtonElement>>, any, StyledEditActionProps, never>;
declare const StyledDeleteButton: import("styled-components").StyledComponent<import("react").ForwardRefExoticComponent<import("../icon-button").IconButtonProps & import("react").RefAttributes<HTMLButtonElement>>, any, CommonPodButtonProps, never>;
declare const StyledUndoButton: import("styled-components").StyledComponent<import("react").ForwardRefExoticComponent<import("../icon-button").IconButtonProps & import("react").RefAttributes<HTMLButtonElement>>, any, CommonPodButtonProps, never>;
interface StyledHeaderProps extends Pick<PodProps, "alignTitle" | "internalEditButton"> {
    size: PodSize;
}
declare const StyledHeader: import("styled-components").StyledComponent<"div", any, StyledHeaderProps, never>;
declare const StyledSubtitle: import("styled-components").StyledComponent<"h5", any, {}, never>;
declare const StyledTitle: import("styled-components").StyledComponent<"h4", any, {}, never>;
export { StyledBlock, StyledContent, StyledEditAction, StyledActionsContainer, StyledDeleteButton, StyledUndoButton, StyledFooter, StyledPod, StyledHeader, StyledSubtitle, StyledTitle, };
