"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _useLocale = _interopRequireDefault(require("../../hooks/__internal__/useLocale"));
var _pod = require("./pod.style");
var _icon = _interopRequireDefault(require("../icon"));
var _events = _interopRequireDefault(require("../../__internal__/utils/helpers/events"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
const Pod = /*#__PURE__*/_react.default.forwardRef(({
  "data-element": dataElement,
  "data-role": dataRole,
  alignTitle = "left",
  border = true,
  children,
  className,
  displayEditButtonOnHover,
  editContentFullWidth,
  footer,
  height,
  internalEditButton,
  onDelete,
  onEdit,
  onUndo,
  size = "medium",
  softDelete,
  subtitle,
  title,
  triggerEditOnContent,
  variant = "primary",
  ...rest
}, ref) => {
  const [isEditFocused, setEditFocused] = (0, _react.useState)(false);
  const [isEditHovered, setEditHovered] = (0, _react.useState)(false);
  const [isDeleteFocused, setDeleteFocused] = (0, _react.useState)(false);
  const [isDeleteHovered, setDeleteHovered] = (0, _react.useState)(false);
  const [isUndoFocused, setUndoFocused] = (0, _react.useState)(false);
  const [isUndoHovered, setUndoHovered] = (0, _react.useState)(false);
  const l = (0, _useLocale.default)();
  const shouldContentHaveEditEvents = (0, _react.useMemo)(() => !!(onEdit && (triggerEditOnContent || displayEditButtonOnHover)), [displayEditButtonOnHover, onEdit, triggerEditOnContent]);
  const hasButtons = (0, _react.useMemo)(() => !!(onEdit || onDelete || onUndo), [onEdit, onDelete, onUndo]);
  const processPodAction = action => ev => {
    if (_events.default.isKeyboardEvent(ev) && _events.default.isEventType(ev, "keydown") && !_events.default.isEnterKey(ev)) return;
    ev.preventDefault();
    action(ev);
  };
  const editEvents = {
    onMouseEnter: () => setEditHovered(true),
    onMouseLeave: () => setEditHovered(false),
    onFocus: () => setEditFocused(true),
    onBlur: () => setEditFocused(false),
    onClick: onEdit && processPodAction(onEdit),
    onKeyDown: onEdit && processPodAction(onEdit)
  };
  return /*#__PURE__*/_react.default.createElement(_pod.StyledPod, _extends({
    alignTitle: alignTitle,
    className: className,
    internalEditButton: internalEditButton,
    height: typeof height === "number" ? `${height}px` : height,
    ref: ref,
    "data-component": "pod",
    "data-element": dataElement,
    "data-role": dataRole
  }, rest), /*#__PURE__*/_react.default.createElement(_pod.StyledBlock, _extends({
    "data-element": "block",
    contentTriggersEdit: shouldContentHaveEditEvents,
    hasButtons: hasButtons,
    fullWidth: editContentFullWidth,
    internalEditButton: internalEditButton,
    isFocused: isEditFocused || isDeleteFocused,
    isHovered: isEditHovered || isDeleteHovered,
    noBorder: !border,
    variant: variant,
    softDelete: softDelete
  }, shouldContentHaveEditEvents && {
    ...editEvents,
    tabIndex: 0
  }), /*#__PURE__*/_react.default.createElement(_pod.StyledContent, {
    "data-element": "content",
    size: size
  }, title && /*#__PURE__*/_react.default.createElement(_pod.StyledHeader, {
    alignTitle: alignTitle,
    internalEditButton: internalEditButton,
    size: size
  }, typeof title === "string" ? /*#__PURE__*/_react.default.createElement(_pod.StyledTitle, {
    "data-element": "title"
  }, title) : title, typeof subtitle === "string" ? /*#__PURE__*/_react.default.createElement(_pod.StyledSubtitle, {
    "data-element": "subtitle"
  }, subtitle) : subtitle), children), footer && /*#__PURE__*/_react.default.createElement(_pod.StyledFooter, {
    "data-element": "footer",
    size: size,
    variant: variant,
    softDelete: softDelete
  }, footer)), hasButtons && /*#__PURE__*/_react.default.createElement(_pod.StyledActionsContainer, {
    "data-element": "action-button-container",
    internalEditButton: internalEditButton
  }, softDelete && onUndo && /*#__PURE__*/_react.default.createElement(_pod.StyledUndoButton, {
    "aria-label": l.pod.undo(),
    onMouseEnter: () => setUndoHovered(true),
    onMouseLeave: () => setUndoHovered(false),
    onFocus: () => setUndoFocused(true),
    onBlur: () => setUndoFocused(false),
    "data-element": "undo",
    internalEditButton: internalEditButton,
    isFocused: isUndoFocused,
    isHovered: isUndoHovered,
    noBorder: !border,
    size: size,
    variant: variant,
    onClick: processPodAction(onUndo)
  }, /*#__PURE__*/_react.default.createElement(_icon.default, {
    type: "undo"
  })), !softDelete && onEdit && /*#__PURE__*/_react.default.createElement(_pod.StyledEditAction, _extends({}, editEvents, {
    "aria-label": l.actions.edit(),
    "data-element": "edit",
    displayOnlyOnHover: displayEditButtonOnHover,
    internalEditButton: internalEditButton,
    isFocused: isEditFocused,
    isHovered: isEditHovered,
    noBorder: !border,
    size: size,
    variant: variant
  }), /*#__PURE__*/_react.default.createElement(_icon.default, {
    type: "edit"
  })), !softDelete && onDelete && /*#__PURE__*/_react.default.createElement(_pod.StyledDeleteButton, {
    "aria-label": l.actions.delete(),
    "data-element": "delete",
    onMouseEnter: () => setDeleteHovered(true),
    onMouseLeave: () => setDeleteHovered(false),
    onFocus: () => setDeleteFocused(true),
    onBlur: () => setDeleteFocused(false),
    internalEditButton: internalEditButton,
    isFocused: isDeleteFocused,
    isHovered: isDeleteHovered,
    noBorder: !border,
    size: size,
    variant: variant,
    onClick: processPodAction(onDelete)
  }, /*#__PURE__*/_react.default.createElement(_icon.default, {
    type: "delete"
  }))));
});
if (process.env.NODE_ENV !== "production") {
  Pod.propTypes = {
    "alignTitle": _propTypes.default.oneOf(["center", "left", "right"]),
    "border": _propTypes.default.bool,
    "children": _propTypes.default.node,
    "className": _propTypes.default.string,
    "data-element": _propTypes.default.string,
    "data-role": _propTypes.default.string,
    "displayEditButtonOnHover": _propTypes.default.bool,
    "editContentFullWidth": _propTypes.default.bool,
    "footer": _propTypes.default.node,
    "height": _propTypes.default.oneOfType([_propTypes.default.number, _propTypes.default.string]),
    "internalEditButton": _propTypes.default.bool,
    "m": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string]),
    "margin": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string]),
    "marginBottom": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string]),
    "marginLeft": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string]),
    "marginRight": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string]),
    "marginTop": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string]),
    "marginX": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string]),
    "marginY": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string]),
    "mb": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string]),
    "ml": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string]),
    "mr": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string]),
    "mt": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string]),
    "mx": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string]),
    "my": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string]),
    "onDelete": _propTypes.default.func,
    "onEdit": _propTypes.default.func,
    "onUndo": _propTypes.default.func,
    "size": _propTypes.default.oneOf(["extra-large", "extra-small", "large", "medium", "small"]),
    "softDelete": _propTypes.default.bool,
    "subtitle": _propTypes.default.node,
    "title": _propTypes.default.node,
    "triggerEditOnContent": _propTypes.default.bool,
    "variant": _propTypes.default.oneOf(["primary", "secondary", "tertiary", "tile", "transparent"])
  };
}
Pod.displayName = "Pod";
var _default = exports.default = Pod;