"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _styledComponents = _interopRequireWildcard(require("styled-components"));
var _polished = require("polished");
var _styledSystem = require("styled-system");
var _pillStyle = _interopRequireDefault(require("./pill.style.config"));
var _themes = require("../../style/themes");
var _icon = _interopRequireDefault(require("../icon/icon.style"));
var _color = require("../../style/utils/color");
var _getColorValue = _interopRequireDefault(require("../../style/utils/get-color-value"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function addStyleToPillIcon(fontSize) {
  return `
    ${_icon.default} {
      &:before {
        font-size: ${fontSize};
      }
    }
  `;
}
const StyledPill = _styledComponents.default.span`
  ${_styledSystem.margin}
  ${({
  wrapText,
  borderColor,
  colorVariant,
  isDarkBackground,
  isDeletable,
  inFill,
  maxWidth,
  pillRole,
  size,
  theme
}) => {
  const isStatus = pillRole === "status";
  let pillColor;
  let buttonFocusColor;
  let contentColor;
  try {
    if (borderColor) {
      pillColor = (0, _color.toColor)(theme, borderColor);
      buttonFocusColor = (0, _polished.shade)(0.2, (0, _getColorValue.default)(pillColor));
      contentColor = (0, _polished.meetsContrastGuidelines)((0, _getColorValue.default)(pillColor), theme.compatibility.colorsUtilityYin090).AAA ? "var(--colorsUtilityYin090)" : "var(--colorsUtilityYang100)";
    } else {
      const {
        status,
        tag
      } = (0, _pillStyle.default)(isDarkBackground);
      const {
        varietyColor,
        buttonFocus,
        content
      } = isStatus ? status[colorVariant] : tag.primary;
      pillColor = varietyColor;
      buttonFocusColor = buttonFocus;
      contentColor = content;
    }
  } catch (e) {
    // eslint-disable-next-line no-console
    console.error(e);
  }
  return (0, _styledComponents.css)`
      font-size: 12px;
      letter-spacing: 0.7px;
      font-weight: 700;
      position: relative;
      display: inline-flex;
      text-align: center;
      align-items: center;
      justify-content: center;
      border: 2px solid ${pillColor};
      ${!theme.roundedCornersOptOut && (0, _styledComponents.css)`
        border-radius: var(--borderRadius025);
      `}
      height: auto;
      ${!wrapText && (0, _styledComponents.css)`
        white-space: nowrap;
      `}
      ${wrapText && (0, _styledComponents.css)`
        white-space: break-spaces;
        hyphens: auto;
      `}
      color: ${contentColor};

      ${inFill && (0, _styledComponents.css)`
        background-color: ${pillColor};
      `}

      ${!inFill && (0, _styledComponents.css)`
        color: ${!isDarkBackground ? "var(--colorsUtilityYin090)" : "var(--colorsUtilityYang100)"};
      `}

      ${size === "S" && (0, _styledComponents.css)`
        min-height: 16px;
        line-height: 16px;
        font-size: 12px;

        ${theme.roundedCornersOptOut && (0, _styledComponents.css)`
          border-radius: 12px;

          button {
            border-radius: 0 10px 10px 0;
          }
        `}
      `}

      ${size === "M" && (0, _styledComponents.css)`
        min-height: 20px;
        line-height: 20px;
        font-size: 14px;

        ${theme.roundedCornersOptOut && (0, _styledComponents.css)`
          border-radius: 12px;

          button {
            border-radius: 0 10px 10px 0;
          }
        `}
      `}

      ${size === "L" && (0, _styledComponents.css)`
        min-height: 24px;
        line-height: 24px;
        font-size: 14px;

        ${theme.roundedCornersOptOut && (0, _styledComponents.css)`
          border-radius: 13px;

          button {
            border-radius: 0 11px 11px 0;
          }
        `}
      `}

      ${size === "XL" && (0, _styledComponents.css)`
        min-height: 28px;
        line-height: 28px;
        font-size: 16px;

        ${theme.roundedCornersOptOut && (0, _styledComponents.css)`
          border-radius: 15px;

          button {
            border-radius: 0 12px 12px 0;
          }
        `}
      `}

      ${isDeletable && (0, _styledComponents.css)`
        button {
          -webkit-appearance: none;
          ${!theme.roundedCornersOptOut && (0, _styledComponents.css)`
            border-radius: var(--borderRadius000);
          `}
          border: none;
          bottom: 0;
          font-size: 100%;
          position: absolute;
          right: 0;
          top: 0;
          width: 20px;
          margin: 0;
          line-height: 16px;

          &:focus {
            ${theme.focusRedesignOptOut && /* istanbul ignore next */
  (0, _styledComponents.css)`
              outline: none;
              box-shadow: 0 0 0 3px var(--colorsSemanticFocus500);
            `}

            background-color: ${buttonFocusColor};
            ${!theme.roundedCornersOptOut && (0, _styledComponents.css)`
              border-radius: var(--borderRadius000) var(--borderRadius025)
                var(--borderRadius025) var(--borderRadius000);
            `}

            & {
              color: ${contentColor};
            }
            ::-moz-focus-inner {
              border: 0;
            }
            ${_icon.default} {
              color: ${contentColor};
            }
          }

          &:hover {
            background-color: ${buttonFocusColor};
            color: ${contentColor};
            cursor: pointer;
            ${_icon.default} {
              color: ${contentColor};
            }
          }

          ${_icon.default} {
            height: unset;
            width: unset;
            color: ${contentColor};

            &:hover,
            &:focus {
              color: ${contentColor};
            }
          }

          ${!inFill && (0, _styledComponents.css)`
            ${_icon.default} {
              color: ${!isDarkBackground ? "var(--colorsUtilityYin090)" : "var(--colorsUtilityYang100)"};
            }
          `}
        }

        ${size === "S" && (0, _styledComponents.css)`
          padding: 0 22px 0 8px;

          button {
            padding: 0;
            line-height: 16px;
            top: -2px;
            ${addStyleToPillIcon("16px")}
          }
        `}

        ${size === "M" && (0, _styledComponents.css)`
          padding: 0 28px 0 8px;

          button {
            width: 24px;
            padding: 0;
            line-height: 15px;
          }
        `}

        ${size === "L" && (0, _styledComponents.css)`
          padding: 0 32px 0 8px;

          button {
            width: 28px;
            padding: 0;
            line-height: 16px;
          }
        `}

        ${size === "XL" && (0, _styledComponents.css)`
          padding: 0 36px 0 12px;

          button {
            width: 32px;
            padding: 0;
            line-height: 18px;
          }
        `}
      `}

      ${!isDeletable && (0, _styledComponents.css)`
        ${size === "S" && (0, _styledComponents.css)`
          padding: 0 8px;

          button {
            padding: 0;
          }
        `}

        ${size === "M" && (0, _styledComponents.css)`
          padding: 0 8px;

          button {
            width: 24px;
            padding: 0;
          }
        `}

        ${size === "L" && (0, _styledComponents.css)`
          padding: 0 8px;

          button {
            width: 28px;
            padding: 0;
          }
        `}

        ${size === "XL" && (0, _styledComponents.css)`
          padding: 0 12px;

          button {
            width: 32px;
            padding: 0;
          }
        `}
      `}
      ${maxWidth && `max-width: ${maxWidth}`}
    `;
}}
`;
StyledPill.defaultProps = {
  inFill: false,
  isDeletable: false,
  theme: _themes.baseTheme
};
var _default = exports.default = StyledPill;