import { MarginProps } from "styled-system";
import { ThemeObject } from "../../style/themes/base/base-theme.config";
export interface StyledPillProps extends MarginProps {
    /** Override color variant, provide any color from palette or any valid css color value. */
    borderColor?: string;
    /** Sets the max-width of the pill. */
    maxWidth?: string;
    /** Sets the size of the pill. */
    size?: "S" | "M" | "L" | "XL";
    /** @private @ignore */
    theme?: Partial<ThemeObject>;
    /** Allow the text within pill to wrap. */
    wrapText?: boolean;
}
interface AllStyledPillProps extends StyledPillProps {
    inFill?: boolean;
    isDeletable: boolean;
    isDarkBackground: boolean;
    colorVariant: "neutral" | "negative" | "positive" | "warning" | "information" | "neutralWhite";
    pillRole: "tag" | "status";
}
declare const StyledPill: import("styled-components").StyledComponent<"span", any, AllStyledPillProps, never>;
export default StyledPill;
