"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.Pill = void 0;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _pill = _interopRequireDefault(require("./pill.style"));
var _icon = _interopRequireDefault(require("../icon"));
var _tags = _interopRequireDefault(require("../../__internal__/utils/helpers/tags/tags"));
var _iconButton = _interopRequireDefault(require("../icon-button"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
let neutralWhiteWarnTriggered = false;
const Pill = ({
  wrapText,
  borderColor,
  colorVariant = "neutral",
  isDarkBackground = false,
  children,
  fill = false,
  maxWidth,
  onClick,
  onDelete,
  pillRole = "tag",
  size = "M",
  ariaLabelOfRemoveButton = "remove pill",
  ...rest
}) => {
  if (!neutralWhiteWarnTriggered && !isDarkBackground && colorVariant === "neutralWhite" && !fill) {
    neutralWhiteWarnTriggered = true;
    // eslint-disable-next-line no-console
    console.warn("[WARNING] The `neutralWhite` variant should only be used on dark backgrounds with fill set to true. " + "Please set the `isDarkBackground` and `fill` props to true or use another color variant.");
  }
  return /*#__PURE__*/_react.default.createElement(_pill.default, _extends({
    inFill: fill,
    colorVariant: colorVariant,
    isDarkBackground: isDarkBackground,
    isDeletable: !!onDelete,
    pillRole: pillRole,
    size: size,
    borderColor: borderColor,
    onClick: onClick
  }, (0, _tags.default)("pill", rest), {
    maxWidth: maxWidth,
    wrapText: wrapText
  }, rest), children, onDelete && /*#__PURE__*/_react.default.createElement(_iconButton.default, {
    onClick: onDelete,
    "data-element": "close",
    "aria-label": ariaLabelOfRemoveButton
  }, /*#__PURE__*/_react.default.createElement(_icon.default, {
    type: "cross"
  })));
};
exports.Pill = Pill;
var _default = exports.default = Pill;