"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.Password = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _password = require("./password.style");
var _guid = _interopRequireDefault(require("../../__internal__/utils/helpers/guid"));
var _tags = _interopRequireDefault(require("../../__internal__/utils/helpers/tags/tags"));
var _useLocale = _interopRequireDefault(require("../../hooks/__internal__/useLocale"));
var _buttonMinor = _interopRequireDefault(require("../button-minor/button-minor.component"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
const Password = ({
  id,
  disabled,
  forceObscurity = false,
  ...rest
}) => {
  const internalInputId = (0, _react.useRef)(id || (0, _guid.default)());
  const l = (0, _useLocale.default)();
  const [passwordShown, setPasswordShown] = (0, _react.useState)(false);
  const visibleInput = !forceObscurity && passwordShown;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_password.StyledPassword, _extends({}, (0, _tags.default)("password", rest), {
    "data-element": "styled-password-container",
    id: internalInputId.current,
    autoComplete: "off",
    type: visibleInput ? "text" : "password",
    disabled: disabled
  }, rest), /*#__PURE__*/_react.default.createElement(_buttonMinor.default, {
    "aria-label": visibleInput ? "Hide password" : "Show password",
    "aria-controls": internalInputId.current,
    onClick: () => setPasswordShown(!passwordShown),
    pr: 1,
    buttonType: "tertiary",
    iconType: visibleInput ? "hide" : "view",
    iconPosition: "before",
    size: "small",
    disabled: forceObscurity || disabled,
    isInPassword: true
  }, visibleInput ? "Hide" : "Show")), /*#__PURE__*/_react.default.createElement(_password.HiddenAriaLive, {
    role: "status",
    "aria-live": "polite"
  }, visibleInput ? l.password.ariaLiveShownMessage() : l.password.ariaLiveHiddenMessage()));
};
exports.Password = Password;
var _default = exports.default = Password;