"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "Page", {
  enumerable: true,
  get: function () {
    return _page.default;
  }
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _reactTransitionGroup = require("react-transition-group");
var _tags = _interopRequireDefault(require("../../__internal__/utils/helpers/tags/tags"));
var _page = _interopRequireDefault(require("./page"));
var _pages = require("./pages.style");
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const NEXT = "next";
const PREVIOUS = "previous";
const TRANSITION_TIME = 500;
const Pages = ({
  pageIndex: incomingPageIndex,
  initialpageIndex = 0,
  transition = "slide",
  children,
  ...props
}) => {
  const [pageIndex, setPageIndex] = (0, _react.useState)(Number(incomingPageIndex) || Number(initialpageIndex));
  const transitionDirection = (0, _react.useRef)(NEXT);
  const transitionName = () => {
    if (transition === "slide") {
      return `slide-${transitionDirection.current}`;
    }
    return `carousel-transition-${transition}`;
  };
  const handleVisiblePage = () => {
    const visiblePage = _react.default.Children.toArray(children)[pageIndex];

    /* istanbul ignore if */
    if (! /*#__PURE__*/_react.default.isValidElement(visiblePage)) return visiblePage;
    const additionalProps = {
      transitionName,
      timeout: TRANSITION_TIME,
      "data-element": "visible-page",
      className: visiblePage.props.className
    };
    return /*#__PURE__*/_react.default.cloneElement(visiblePage, additionalProps);
  };
  const numOfPages = (0, _react.useCallback)(() => {
    return Array.isArray(children) ? children.length : 1;
  }, [children]);
  const verifyNewIndex = (0, _react.useCallback)(newIndex => {
    if (newIndex < 0) {
      // If the new index is negative, select the last page
      return numOfPages() - 1;
    }
    if (newIndex > numOfPages() - 1) {
      // If the new index is bigger than the number of slides, select the first page
      return 0;
    }
    return newIndex;
  }, [numOfPages]);
  (0, _react.useEffect)(() => {
    if (typeof incomingPageIndex === "undefined") return;
    const newIndex = verifyNewIndex(incomingPageIndex); // 2
    const currentIndex = pageIndex; // 1

    if (newIndex === currentIndex) return;
    if (newIndex > currentIndex) {
      transitionDirection.current = NEXT;
    } else {
      transitionDirection.current = PREVIOUS;
    }
    setPageIndex(newIndex);
  }, [incomingPageIndex, pageIndex, verifyNewIndex]);

  /** Renders the Slide Component */
  return /*#__PURE__*/_react.default.createElement(_pages.PagesWrapperStyle, (0, _tags.default)("carousel", props), /*#__PURE__*/_react.default.createElement(_pages.PagesContent, {
    className: "carbon-carousel__content"
  }, /*#__PURE__*/_react.default.createElement(_reactTransitionGroup.TransitionGroup, null, handleVisiblePage())));
};
Pages.displayName = "Pages";
var _default = exports.default = Pages;