"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _reactTransitionGroup = require("react-transition-group");
var _tags = _interopRequireDefault(require("../../../__internal__/utils/helpers/tags/tags"));
var _fullScreenHeading = _interopRequireDefault(require("../../../__internal__/full-screen-heading"));
var _box = _interopRequireDefault(require("../../box"));
var _page = require("./page.style");
var _utils = require("../../../style/utils");
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
const Page = ({
  role,
  title,
  children,
  ...rest
}) => {
  const styledPageNodeRef = (0, _react.useRef)(null);
  const {
    transitionName
  } = rest;
  return /*#__PURE__*/_react.default.createElement(_reactTransitionGroup.CSSTransition, _extends({
    className: "carbon-carousel__transition",
    timeout: {
      appear: 0,
      enter: 0,
      exit: 0
    }
  }, transitionName && {
    classNames: transitionName()
  }, {
    nodeRef: styledPageNodeRef
  }, rest), /*#__PURE__*/_react.default.createElement(_page.StyledPage, _extends({}, (0, _tags.default)("page", rest), {
    ref: styledPageNodeRef,
    role: role
  }), /*#__PURE__*/_react.default.createElement(_fullScreenHeading.default, {
    hasContent: true
  }, title), /*#__PURE__*/_react.default.createElement(_page.StyledPageContent, _extends({
    "data-element": "carbon-page-content",
    p: "34px 40px"
  }, (0, _utils.filterStyledSystemPaddingProps)(rest)), /*#__PURE__*/_react.default.createElement(_box.default, {
    boxSizing: "border-box",
    maxWidth: "100%",
    minWidth: "auto",
    margin: "0 auto"
  }, children))));
};
Page.displayName = "Page";
var _default = exports.default = Page;