"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StyledSelectContainer = exports.StyledPagerSummary = exports.StyledPagerSizeOptionsInner = exports.StyledPagerSizeOptions = exports.StyledPagerNoSelect = exports.StyledPagerNavigation = exports.StyledPagerNavLabel = exports.StyledPagerNavInner = exports.StyledPagerLink = exports.StyledPagerContainer = void 0;
var _styledComponents = _interopRequireWildcard(require("styled-components"));
var _input = _interopRequireDefault(require("../../__internal__/input/input.style"));
var _inputPresentation = _interopRequireDefault(require("../../__internal__/input/input-presentation.style"));
var _formField = _interopRequireDefault(require("../../__internal__/form-field/form-field.style"));
var _inputIconToggle = _interopRequireDefault(require("../../__internal__/input-icon-toggle/input-icon-toggle.style"));
var _selectText = require("../select/__internal__/select-text/select-text.style");
var _link = _interopRequireDefault(require("../link"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const StyledSelectContainer = exports.StyledSelectContainer = _styledComponents.default.div`
  height: 26px;
  width: 55px;
  margin-left: 8px;
  margin-right: 8px;
  ${_inputPresentation.default} {
    padding-left: 0;
  }
`;
const StyledPagerContainer = exports.StyledPagerContainer = _styledComponents.default.div`
  display: flex;
  justify-content: space-between;
  padding: 0px 24px;
  align-items: center;
  font-size: 13px;
  color: var(--colorsUtilityYin090);
  border: 1px solid var(--colorsUtilityMajor100);
  border-radius: var(--borderRadius100);

  ${({
  variant
}) => (0, _styledComponents.css)`
      background-color: ${variant === "alternate" ? "var(--colorsUtilityMajor040)" : "var(--colorsUtilityMajor010)"};
    `}
`;
const StyledPagerSizeOptions = exports.StyledPagerSizeOptions = _styledComponents.default.div`
  display: flex;
  flex: 1 1 30%;
  justify-content: flex-start;

  ${_inputPresentation.default} {
    width: 55px;
    height: 26px;
    min-height: 26px;
    min-width: 10px;
    margin: 0px;

    ${_selectText.StyledSelectText} {
      font-size: 14px;
      padding-right: 0px;
      padding-left: 8px;
      height: 22px;
      width: 13px;
    }

    ${_inputIconToggle.default} {
      margin-left: 0;
      width: 20px;
      height: 24px;
    }
  }
`;
const StyledPagerSizeOptionsInner = exports.StyledPagerSizeOptionsInner = _styledComponents.default.div`
  display: flex;
  align-items: center;
`;
const StyledPagerNavigation = exports.StyledPagerNavigation = _styledComponents.default.div`
  display: flex;
  flex: 1 1 auto;
  justify-content: center;
  align-items: center;

  && ${_inputPresentation.default} {
    padding: 0;
    margin: 4px 8px;
    height: 26px;
    line-height: 26px;
    min-height: 24px;

    ${_input.default} {
      text-align: center;
      height: 24px;
      padding: 0;
    }
  }
`;
const StyledPagerNavInner = exports.StyledPagerNavInner = _styledComponents.default.div`
  display: flex;
  align-items: center;
  padding: 0 12px;
  margin: 4px 0;

  && ${_formField.default} {
    margin-bottom: 0;
  }
`;
const StyledPagerNavLabel = exports.StyledPagerNavLabel = _styledComponents.default.label`
  white-space: nowrap;
  padding: 9px 12px;
  margin: 4px 0;
`;
const StyledPagerLink = exports.StyledPagerLink = (0, _styledComponents.default)(_link.default)`
  margin-left: 17px;
  margin-right: 17px;

  ${({
  hideDisabledButtons
}) => hideDisabledButtons && (0, _styledComponents.css)`
      & {
        visibility: hidden;
      }
    `}
`;
const StyledPagerNoSelect = exports.StyledPagerNoSelect = _styledComponents.default.div`
  user-select: none;
  white-space: nowrap;
  font-weight: normal;
`;
const StyledPagerSummary = exports.StyledPagerSummary = _styledComponents.default.div`
  display: flex;
  flex: 1 1 30%;
  justify-content: flex-end;
`;