"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.Pager = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _select = require("../select");
var _pagerNavigation = _interopRequireDefault(require("./__internal__/pager-navigation.component"));
var _useLocale = _interopRequireDefault(require("../../hooks/__internal__/useLocale"));
var _guid = _interopRequireDefault(require("../../__internal__/utils/helpers/guid"));
var _pager = require("./pager.style");
var _events = _interopRequireDefault(require("../../__internal__/utils/helpers/events"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
const Pager = ({
  currentPage = 1,
  hideDisabledElements = false,
  interactivePageNumber = true,
  pageSizeSelectionOptions = [{
    id: "10",
    name: 10
  }, {
    id: "25",
    name: 25
  }, {
    id: "50",
    name: 50
  }, {
    id: "100",
    name: 100
  }],
  pageSize = 10,
  showPageSizeSelection = false,
  totalRecords = 0,
  onPagination,
  onNext,
  onFirst,
  onPrevious,
  onLast,
  showPageSizeLabelBefore = true,
  showPageSizeLabelAfter = true,
  showTotalRecords = true,
  showFirstAndLastButtons = true,
  showPreviousAndNextButtons = true,
  showPageCount = true,
  variant = "default",
  ...rest
}) => {
  const l = (0, _useLocale.default)();
  const [page, setPage] = (0, _react.useState)(+currentPage);
  const [currentPageSize, setCurrentPageSize] = (0, _react.useState)(+pageSize);
  const [value, setValue] = (0, _react.useState)(+pageSize);
  const guid = (0, _react.useRef)((0, _guid.default)());
  const pageSizeSelectId = `Pager_size_selector_${guid.current}`;
  const getPageCount = (0, _react.useCallback)(() => {
    if (+totalRecords < 0 || Number.isNaN(+totalRecords)) {
      return 1;
    }
    return Math.ceil(+totalRecords / currentPageSize);
  }, [totalRecords, currentPageSize]);
  const [pageCount, setPageCount] = (0, _react.useState)(getPageCount());
  (0, _react.useEffect)(() => {
    setCurrentPageSize(+pageSize);
    setValue(+pageSize);
  }, [pageSize]);
  (0, _react.useEffect)(() => {
    const maxPage = getPageCount();
    setPageCount(maxPage);
    if (+currentPage > maxPage) {
      setPage(maxPage);
    } else {
      setPage(+currentPage);
    }
  }, [currentPageSize, pageCount, currentPage, totalRecords, getPageCount]);
  const handleOnFirst = (0, _react.useCallback)(e => {
    setPage(1);
    if (onFirst) {
      onFirst(e);
    }
  }, [onFirst]);
  const handleOnLast = (0, _react.useCallback)(e => {
    setPage(pageCount);
    if (onLast) {
      onLast(e);
    }
  }, [pageCount, onLast]);
  const handleOnNext = (0, _react.useCallback)(e => {
    const nextPage = page + 1;
    setPage(nextPage);
    if (onNext) {
      onNext(e);
    }
  }, [onNext, page]);
  const handleOnPrevious = (0, _react.useCallback)(e => {
    const previousPage = page - 1;
    setPage(previousPage);
    if (onPrevious) {
      onPrevious(e);
    }
  }, [page, onPrevious]);
  const handleOnPagination = (0, _react.useCallback)(selectedValue => {
    setValue(selectedValue);
    setCurrentPageSize(+selectedValue);
    onPagination(1, +selectedValue, "page-select");
  }, [onPagination]);
  const handleKeyDown = (0, _react.useCallback)(e => _events.default.isEnterKey(e) && handleOnPagination(e.target.value), [handleOnPagination]);
  const sizeSelector = () => {
    return /*#__PURE__*/_react.default.createElement(_pager.StyledSelectContainer, null, /*#__PURE__*/_react.default.createElement(_select.Select, _extends({
      value: String(value),
      onChange: ev => setValue(+ev.target.value),
      onBlur: () => setValue(currentPageSize),
      onKeyDown: handleKeyDown,
      "data-element": "page-select",
      id: pageSizeSelectId
    }, !showPageSizeLabelBefore && !showPageSizeLabelAfter ? {
      ariaLabel: l.pager.show()
    } : {}), pageSizeSelectionOptions.map(sizeOption => /*#__PURE__*/_react.default.createElement(_select.Option, {
      key: sizeOption.id,
      text: sizeOption.id,
      value: String(sizeOption.name),
      onClick: handleOnPagination
    }))));
  };
  const renderPageSizeOptions = () => {
    const wrapper = (isLabel, child) => isLabel ? /*#__PURE__*/_react.default.createElement("label", {
      htmlFor: pageSizeSelectId
    }, child) : /*#__PURE__*/_react.default.createElement("div", null, child);
    return showPageSizeSelection && /*#__PURE__*/_react.default.createElement(_pager.StyledPagerSizeOptionsInner, null, showPageSizeLabelBefore && wrapper(showPageSizeLabelBefore, l.pager.show()), sizeSelector(), showPageSizeLabelAfter && wrapper(!showPageSizeLabelBefore, l.pager.records(currentPageSize, false)));
  };
  const renderTotalRecords = () => showTotalRecords && l.pager.records(totalRecords);
  return /*#__PURE__*/_react.default.createElement(_pager.StyledPagerContainer, _extends({
    "data-component": "pager",
    variant: variant
  }, rest), /*#__PURE__*/_react.default.createElement(_pager.StyledPagerSizeOptions, null, renderPageSizeOptions()), /*#__PURE__*/_react.default.createElement(_pagerNavigation.default, {
    pageSize: currentPageSize,
    currentPage: page,
    interactivePageNumber: interactivePageNumber,
    hideDisabledElements: hideDisabledElements,
    setCurrentPage: setPage,
    onNext: handleOnNext,
    onPrevious: handleOnPrevious,
    onFirst: handleOnFirst,
    onLast: handleOnLast,
    onPagination: onPagination,
    pageCount: pageCount,
    showFirstAndLastButtons: showFirstAndLastButtons,
    showPreviousAndNextButtons: showPreviousAndNextButtons,
    showPageCount: showPageCount
  }), /*#__PURE__*/_react.default.createElement(_pager.StyledPagerSummary, null, renderTotalRecords()));
};
exports.Pager = Pager;
var _default = exports.default = Pager;