import React from "react";
declare type PageSizeOption = {
    id: string;
    name: number;
};
export interface PagerProps {
    /** Function called when pager changes (Current page, Page size, Origin component) */
    onPagination: (currentPage: number, pageSize: number, origin: string) => void;
    /** Callback function for next link */
    onNext?: (ev: React.MouseEvent<HTMLButtonElement> | React.KeyboardEvent<HTMLButtonElement>) => void;
    /** Callback function for first link */
    onFirst?: (ev: React.MouseEvent<HTMLButtonElement> | React.KeyboardEvent<HTMLButtonElement>) => void;
    /** Callback function for previous link */
    onPrevious?: (ev: React.MouseEvent<HTMLButtonElement> | React.KeyboardEvent<HTMLButtonElement>) => void;
    /** Callback function for last link */
    onLast?: (ev: React.MouseEvent<HTMLButtonElement> | React.KeyboardEvent<HTMLButtonElement>) => void;
    /** Current visible page */
    currentPage?: number | string;
    /** If true, page number navigation will be changed to a non-interactive label */
    interactivePageNumber?: boolean;
    /** If true, sets css property visibility: hidden on all disabled elements  */
    hideDisabledElements?: boolean;
    /** Total number of records */
    totalRecords?: number | string;
    /** Pagination page size */
    pageSize?: number | string;
    /** Should the page size selection dropdown be shown */
    showPageSizeSelection?: boolean;
    /** Set of page size options */
    pageSizeSelectionOptions?: PageSizeOption[];
    /** Should the label before the page size selection dropdown be shown */
    showPageSizeLabelBefore?: boolean;
    /** Should the label after the page size selection dropdown be shown */
    showPageSizeLabelAfter?: boolean;
    /** Should the total records label be shown */
    showTotalRecords?: boolean;
    /** Should the `First` and `Last` navigation button be shown */
    showFirstAndLastButtons?: boolean;
    /** Should the `Previous` and `Next` navigation button be shown */
    showPreviousAndNextButtons?: boolean;
    /** Should the page count input be shown */
    showPageCount?: boolean;
    /** What variant the Pager background should be */
    variant?: "default" | "alternate";
}
export declare const Pager: ({ currentPage, hideDisabledElements, interactivePageNumber, pageSizeSelectionOptions, pageSize, showPageSizeSelection, totalRecords, onPagination, onNext, onFirst, onPrevious, onLast, showPageSizeLabelBefore, showPageSizeLabelAfter, showTotalRecords, showFirstAndLastButtons, showPreviousAndNextButtons, showPageCount, variant, ...rest }: PagerProps) => React.JSX.Element;
export default Pager;
