"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _pager = require("../pager.style");
var _number = _interopRequireDefault(require("../../number"));
var _events = _interopRequireDefault(require("../../../__internal__/utils/helpers/events"));
var _guid = _interopRequireDefault(require("../../../__internal__/utils/helpers/guid"));
var _pagerNavigationLink = _interopRequireDefault(require("./pager-navigation-link.component"));
var _useLocale = _interopRequireDefault(require("../../../hooks/__internal__/useLocale"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
const PagerNavigation = ({
  pageSize,
  currentPage,
  setCurrentPage,
  onNext,
  onPrevious,
  onFirst,
  onLast,
  onPagination,
  pageCount,
  showFirstAndLastButtons = true,
  showPreviousAndNextButtons = true,
  showPageCount = true,
  interactivePageNumber = true,
  hideDisabledElements = false
}) => {
  const l = (0, _useLocale.default)();
  const guid = (0, _react.useRef)((0, _guid.default)());
  const currentPageId = `Pager_${guid.current}`;
  const navLabelString = `${l.pager.pageX()} ${currentPage.toString()} ${l.pager.ofY(pageCount)}`;
  const hasOnePage = pageCount <= 1;
  const hasTwoPages = pageCount === 2;
  const pagerNavigationProps = {
    currentPage,
    pageSize,
    pageCount,
    onPagination
  };
  const handlePageInputChange = ev => {
    const pageNumber = +ev.target.value;
    if (pageCount === 0) {
      setCurrentPage(0);
      onPagination(0, pageSize, "input");
      return 0;
    }
    if (pageNumber <= 0 || Number.isNaN(pageNumber)) {
      setCurrentPage(1);
      onPagination(1, pageSize, "input");
      return 1;
    }
    if (pageNumber > pageCount) {
      setCurrentPage(pageCount);
      onPagination(pageCount, pageSize, "input");
      return pageCount;
    }
    setCurrentPage(pageNumber);
    onPagination(pageNumber, pageSize, "input");
    return pageNumber;
  };
  const handleCurrentPageChange = e => {
    setCurrentPage(+e.target.value);
  };
  const renderButtonsBeforeCount = () => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, !hasTwoPages && showFirstAndLastButtons && /*#__PURE__*/_react.default.createElement(_pagerNavigationLink.default, _extends({
    type: "first",
    hideDisabledElements: hideDisabledElements,
    onClick: onFirst
  }, pagerNavigationProps)), showPreviousAndNextButtons && /*#__PURE__*/_react.default.createElement(_pagerNavigationLink.default, _extends({
    type: "previous",
    hideDisabledElements: hideDisabledElements,
    onClick: onPrevious
  }, pagerNavigationProps)));
  const renderButtonsAfterCount = () => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, showPreviousAndNextButtons && /*#__PURE__*/_react.default.createElement(_pagerNavigationLink.default, _extends({
    type: "next",
    hideDisabledElements: hideDisabledElements,
    onClick: onNext
  }, pagerNavigationProps)), !hasTwoPages && showFirstAndLastButtons && /*#__PURE__*/_react.default.createElement(_pagerNavigationLink.default, _extends({
    type: "last",
    hideDisabledElements: hideDisabledElements,
    onClick: onLast
  }, pagerNavigationProps)));
  return /*#__PURE__*/_react.default.createElement(_pager.StyledPagerNavigation, null, !hasOnePage && renderButtonsBeforeCount(), showPageCount && (interactivePageNumber ? /*#__PURE__*/_react.default.createElement(_pager.StyledPagerNavInner, null, /*#__PURE__*/_react.default.createElement("label", {
    htmlFor: currentPageId
  }, /*#__PURE__*/_react.default.createElement(_pager.StyledPagerNoSelect, null, l.pager.pageX())), /*#__PURE__*/_react.default.createElement(_number.default, {
    value: currentPage.toString(),
    "data-element": "current-page",
    onChange: handleCurrentPageChange,
    onBlur: handlePageInputChange,
    id: currentPageId,
    onKeyUp: ev => _events.default.isEnterKey(ev) ? handlePageInputChange(ev) : false
  }), /*#__PURE__*/_react.default.createElement(_pager.StyledPagerNoSelect, null, l.pager.ofY(pageCount))) : /*#__PURE__*/_react.default.createElement(_pager.StyledPagerNavLabel, {
    "data-element": "current-page-label",
    id: currentPageId,
    "aria-live": "polite"
  }, navLabelString)), !hasOnePage && renderButtonsAfterCount());
};
var _default = exports.default = PagerNavigation;