"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _pager = require("../pager.style");
var _useLocale = _interopRequireDefault(require("../../../hooks/__internal__/useLocale"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const PagerNavigationLink = ({
  type,
  currentPage,
  pageCount,
  hideDisabledElements,
  pageSize,
  onClick,
  onPagination
}) => {
  const l = (0, _useLocale.default)();
  const linkRef = (0, _react.useRef)(null);
  const navLinkConfig = {
    first: {
      text: l.pager.first(),
      destination: 1
    },
    last: {
      text: l.pager.last(),
      destination: pageCount
    },
    next: {
      text: l.pager.next(),
      destination: currentPage + 1
    },
    previous: {
      text: l.pager.previous(),
      destination: currentPage - 1
    }
  };
  const disabled = (0, _react.useCallback)(() => {
    if (currentPage === 1) {
      return type === "previous" || type === "first";
    }
    if (currentPage === pageCount) {
      return type === "next" || type === "last";
    }
    return false;
  }, [pageCount, currentPage, type]);
  (0, _react.useEffect)(() => {
    if (disabled() && linkRef.current) {
      linkRef.current.blur();
    }
  }, [disabled]);
  const handleOnClick = ev => {
    onClick?.(ev);
    onPagination?.(navLinkConfig[type].destination, pageSize, type);
  };
  const {
    text
  } = navLinkConfig[type];
  const hideDisabledButtons = hideDisabledElements && disabled();
  return /*#__PURE__*/_react.default.createElement(_pager.StyledPagerLink, {
    hideDisabledButtons: hideDisabledButtons,
    "data-element": `pager-link-${type}`,
    disabled: disabled(),
    onClick:
    // Type assertion due to the fact that StyledPagerLink
    // will always return a button element
    handleOnClick,
    ref: linkRef
  }, text);
};
var _default = exports.default = PagerNavigationLink;