"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StyledNumeralDate = exports.StyledDateField = void 0;
var _styledComponents = _interopRequireWildcard(require("styled-components"));
var _validationIcon = _interopRequireDefault(require("../../__internal__/validations/validation-icon.style"));
var _inputIconToggle = _interopRequireDefault(require("../../__internal__/input-icon-toggle/input-icon-toggle.style"));
var _inputPresentation = _interopRequireDefault(require("../../__internal__/input/input-presentation.style"));
var _input = _interopRequireDefault(require("../../__internal__/input/input.style"));
var _formField = _interopRequireDefault(require("../../__internal__/form-field/form-field.style"));
var _label = _interopRequireDefault(require("../../__internal__/label/label.style"));
var _textbox = require("../textbox/textbox.style");
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const StyledNumeralDate = exports.StyledNumeralDate = _styledComponents.default.div`
  display: inline-flex;
  font-size: 14px;
  font-weight: 400;

  ${_formField.default} {
    margin-top: 0px;
  }
  ${_label.default} {
    font-weight: 400;
  }

  ${_textbox.StyledHintText} {
    color: var(--colorsUtilityYin090);
  }
`;
const StyledDateField = exports.StyledDateField = _styledComponents.default.div`
  ${({
  isYearInput,
  isEnd,
  hasValidationIconInField
}) => {
  return (0, _styledComponents.css)`
      ${_inputPresentation.default} {
        position: relative;
        margin-right: ${isEnd ? "0" : "12px"};
        min-width: ${isYearInput ? "80px" : "55px"};

        ${_input.default} {
          text-align: center;
          padding: 0 12px;
          ${hasValidationIconInField && isEnd && "padding-right: 0"}
        }

        ${_inputIconToggle.default} {
          width: 32px;
          z-index: 999;
        }

        ${_validationIcon.default} {
          z-index: 9000;
        }
      }
    `;
}}
`;