"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.NumeralDate = exports.ALLOWED_DATE_FORMATS = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _invariant = _interopRequireDefault(require("invariant"));
var _utils = require("../../style/utils");
var _events = _interopRequireDefault(require("../../__internal__/utils/helpers/events"));
var _numeralDate = require("./numeral-date.style");
var _textbox = _interopRequireDefault(require("../textbox"));
var _box = _interopRequireDefault(require("../box"));
var _typography = _interopRequireDefault(require("../typography"));
var _textbox2 = require("../textbox/textbox.style");
var _validationMessage = _interopRequireDefault(require("../../__internal__/validation-message"));
var _guid = _interopRequireDefault(require("../../__internal__/utils/helpers/guid"));
var _useLocale = _interopRequireDefault(require("../../hooks/__internal__/useLocale"));
var _formField = _interopRequireDefault(require("../../__internal__/form-field"));
var _inputBehaviour = require("../../__internal__/input-behaviour");
var _tooltipProvider = require("../../__internal__/tooltip-provider");
var _carbonProvider = require("../carbon-provider/carbon-provider.component");
var _numeralDateContext = _interopRequireDefault(require("./numeral-date-context"));
var _formSpacingProvider = _interopRequireDefault(require("../../__internal__/form-spacing-provider"));
var _logger = _interopRequireDefault(require("../../__internal__/utils/logger"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
let deprecateUncontrolledWarnTriggered = false;
const ALLOWED_DATE_FORMATS = exports.ALLOWED_DATE_FORMATS = [["dd", "mm", "yyyy"], ["mm", "dd", "yyyy"], ["yyyy", "mm", "dd"], ["dd", "mm"], ["mm", "dd"], ["mm", "yyyy"]];
const incorrectDateFormatMessage = "Forbidden prop dateFormat supplied to NumeralDate. " + "Only one of these date formats is allowed: " + "['dd', 'mm', 'yyyy'], " + "['mm', 'dd', 'yyyy'], " + "['yyyy', 'mm', 'dd'], " + "['dd', 'mm'], " + "['mm', 'dd'], " + "['mm', 'yyyy']";
const getMonthsForLocale = localeName => {
  const year = new Date().getFullYear();
  const {
    format
  } = new Intl.DateTimeFormat(localeName, {
    month: "long"
  });
  return [...Array(12).keys()].map(m => format(new Date(Date.UTC(year, m))));
};
const validationMessages = (locale, month, daysInMonth) => ({
  dd: locale.numeralDate.validation.day(month ? getMonthsForLocale(locale.locale())[+month - 1] : undefined, daysInMonth),
  mm: locale.numeralDate.validation.month(),
  yyyy: locale.numeralDate.validation.year()
});
const getDaysInMonth = (month, year) => {
  if (!month || +month > 12 || +month < 1) {
    return 31;
  }
  const currentDate = new Date();
  const computedYear = +(year || currentDate.getFullYear());

  // passing 0 as the third argument ensures we handle for months being 0 indexed
  return new Date(computedYear, +month, 0).getDate();
};
const validate = (locale, {
  dd,
  mm,
  yyyy
}) => {
  const failed = {
    dd: "",
    mm: "",
    yyyy: ""
  };
  const daysInMonth = getDaysInMonth(mm, yyyy);
  if (dd && (+dd > daysInMonth || +dd < 1)) {
    failed.dd = validationMessages(locale, mm, String(daysInMonth)).dd;
  }
  if (mm && (+mm > 12 || +mm < 1)) {
    failed.mm = validationMessages(locale).mm;
  }
  if (yyyy && (+yyyy < 1800 || +yyyy > 2200)) {
    failed.yyyy = validationMessages(locale).yyyy;
  }
  return failed;
};
const getDateLabel = (datePart, locale) => {
  switch (datePart) {
    case "mm":
      return locale.numeralDate.labels.month();
    case "yyyy":
      return locale.numeralDate.labels.year();
    default:
      return locale.numeralDate.labels.day();
  }
};
const NumeralDate = ({
  dateFormat = ["dd", "mm", "yyyy"],
  defaultValue,
  disabled,
  error = "",
  warning = "",
  "data-component": dataComponent,
  "data-element": dataElement,
  "data-role": dataRole,
  info,
  id,
  name,
  onBlur,
  onChange,
  value,
  validationOnLabel = false,
  label,
  labelInline,
  labelWidth,
  labelAlign,
  labelHelp,
  labelSpacing,
  fieldHelp,
  adaptiveLabelBreakpoint,
  required,
  isOptional,
  readOnly,
  size,
  enableInternalError,
  enableInternalWarning,
  tooltipPosition,
  helpAriaLabel,
  dayRef,
  monthRef,
  yearRef,
  ...rest
}) => {
  const locale = (0, _useLocale.default)();
  const {
    validationRedesignOptIn
  } = (0, _react.useContext)(_carbonProvider.NewValidationContext);
  const {
    current: uniqueId
  } = (0, _react.useRef)(id || (0, _guid.default)());
  const isControlled = (0, _react.useRef)(value !== undefined);
  const initialValue = isControlled.current ? value : defaultValue;
  const refs = (0, _react.useRef)(dateFormat.map(() => null));
  const labelIds = (0, _react.useRef)([(0, _guid.default)(), (0, _guid.default)(), (0, _guid.default)()]);
  const [internalMessages, setInternalMessages] = (0, _react.useState)({
    ...Object.fromEntries(dateFormat.map(datePart => [datePart, ""]))
  });
  const hasCorrectDateFormat = (0, _react.useMemo)(() => {
    const isAllowed = !dateFormat || ALLOWED_DATE_FORMATS.find(allowedDateFormat => JSON.stringify(allowedDateFormat) === JSON.stringify(dateFormat));
    return isAllowed;
  }, [dateFormat]);
  !hasCorrectDateFormat ? process.env.NODE_ENV !== "production" ? (0, _invariant.default)(false, incorrectDateFormatMessage) : (0, _invariant.default)(false) : void 0;
  (0, _react.useEffect)(() => {
    const modeSwitchedMessage = "Input elements should not switch from uncontrolled to controlled (or vice versa). " + "Decide between using a controlled or uncontrolled input element for the lifetime of the component";
    !(isControlled.current === (value !== undefined)) ? process.env.NODE_ENV !== "production" ? (0, _invariant.default)(false, modeSwitchedMessage) : (0, _invariant.default)(false) : void 0;
  }, [value]);
  const [dateValue, setDateValue] = (0, _react.useState)({
    ...(initialValue || Object.fromEntries(dateFormat.map(datePart => [datePart, ""])))
  });
  const createCustomEventObject = newValue => ({
    target: {
      name,
      id: uniqueId,
      value: newValue
    }
  });
  const onKeyDown = event => {
    const isValidKey = _events.default.isNumberKey(event) || _events.default.isTabKey(event) || event.key === "Delete" || event.key === "Backspace";
    if (!isValidKey) {
      event.preventDefault();
    }
  };
  const handleChange = (event, datePart) => {
    const {
      value: newValue
    } = event.target;
    if (newValue.length <= datePart.length) {
      const newDateValue = {
        ...dateValue,
        [datePart]: newValue
      };
      setDateValue(newDateValue);

      /* istanbul ignore else */
      if (onChange) {
        onChange(createCustomEventObject(newDateValue));
      }
    }
  };
  const handleBlur = () => {
    const internalValidationEnabled = enableInternalError || enableInternalWarning;
    /* istanbul ignore else */
    if (internalValidationEnabled) {
      setInternalMessages(prev => ({
        ...prev,
        ...validate(locale, dateValue)
      }));
    }
    setTimeout(() => {
      const hasBlurred = !refs.current.find(ref => ref === document.activeElement);
      /* istanbul ignore else */
      if (onBlur && hasBlurred) {
        onBlur(createCustomEventObject(dateValue));
      }
    }, 5);
  };
  const internalMessage = Object.keys(internalMessages).reduce((combinedMessage, datePart) => internalMessages[datePart] ? `${combinedMessage + internalMessages[datePart]}\n` : combinedMessage, "");
  const internalError = enableInternalError ? internalMessage + error : error;
  const internalWarning = enableInternalWarning ? internalMessage + warning : warning;
  if (!deprecateUncontrolledWarnTriggered && !isControlled.current) {
    deprecateUncontrolledWarnTriggered = true;
    _logger.default.deprecate("Uncontrolled behaviour in `Numeral Date` is deprecated and support will soon be removed. Please make sure all your inputs are controlled.");
  }
  return /*#__PURE__*/_react.default.createElement(_tooltipProvider.TooltipProvider, {
    helpAriaLabel: helpAriaLabel
  }, /*#__PURE__*/_react.default.createElement(_inputBehaviour.InputGroupBehaviour, null, /*#__PURE__*/_react.default.createElement(_formField.default, _extends({
    "data-component": dataComponent,
    "data-element": dataElement,
    "data-role": dataRole,
    disabled: disabled,
    useValidationIcon: validationOnLabel,
    id: uniqueId,
    error: internalError,
    warning: internalWarning,
    info: info,
    label: label,
    labelInline: labelInline,
    labelWidth: labelWidth,
    labelAlign: labelAlign,
    labelHelp: !validationRedesignOptIn && labelHelp,
    labelSpacing: labelSpacing,
    fieldHelp: fieldHelp,
    adaptiveLabelBreakpoint: adaptiveLabelBreakpoint,
    isRequired: required,
    isOptional: isOptional,
    validationRedesignOptIn: validationRedesignOptIn
  }, (0, _utils.filterStyledSystemMarginProps)(rest)), validationRedesignOptIn && labelHelp && /*#__PURE__*/_react.default.createElement(_textbox2.StyledHintText, null, labelHelp), /*#__PURE__*/_react.default.createElement(_box.default, {
    position: "relative"
  }, validationRedesignOptIn && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_validationMessage.default, {
    error: internalError,
    warning: internalWarning
  }), (internalError || internalWarning) && /*#__PURE__*/_react.default.createElement(_textbox2.ErrorBorder, {
    warning: !!(!internalError && internalWarning)
  })), /*#__PURE__*/_react.default.createElement(_numeralDate.StyledNumeralDate, {
    name: name,
    onKeyDown: onKeyDown,
    "data-component": "numeral-date"
  }, dateFormat.map((datePart, index) => {
    const isEnd = index === dateFormat.length - 1;
    const labelId = labelIds.current[index];
    const validation = internalError || internalWarning || info;
    const isStringValidation = typeof validation === "string";
    const hasValidationIcon = isStringValidation && !!validation.length;
    let inputRef;
    switch (datePart.slice(0, 2)) {
      case "dd":
        inputRef = dayRef;
        break;
      case "mm":
        inputRef = monthRef;
        break;
      case "yy":
        inputRef = yearRef;
        break;
      /* istanbul ignore next */
      default:
        break;
    }
    return /*#__PURE__*/_react.default.createElement(_numeralDateContext.default.Provider, {
      value: {
        disableErrorBorder: true
      },
      key: datePart
    }, /*#__PURE__*/_react.default.createElement(_numeralDate.StyledDateField, {
      key: datePart,
      isYearInput: datePart.length === 4,
      isEnd: isEnd,
      hasValidationIconInField: hasValidationIcon && !validationOnLabel && !validationRedesignOptIn
    }, /*#__PURE__*/_react.default.createElement(_formSpacingProvider.default, {
      marginBottom: undefined
    }, /*#__PURE__*/_react.default.createElement(_typography.default, {
      mb: "4px",
      id: labelId
    }, getDateLabel(datePart, locale)), /*#__PURE__*/_react.default.createElement(_textbox.default, _extends({}, index === 0 && {
      id: uniqueId
    }, {
      disabled: disabled,
      readOnly: readOnly,
      value: dateValue[datePart],
      onChange: e => handleChange(e, datePart),
      onBlur: handleBlur,
      ref: element => {
        refs.current[index] = element;
        if (!inputRef) {
          return;
        }
        if (typeof inputRef === "function") {
          inputRef(element);
        } else {
          inputRef.current = element;
        }
      },
      error: !!internalError,
      warning: !!internalWarning,
      info: !!info
    }, isEnd && !validationRedesignOptIn && !validationOnLabel && {
      error: internalError,
      warning: internalWarning,
      info
    }, {
      size: size,
      tooltipPosition: tooltipPosition,
      "aria-labelledby": labelId,
      required: required
    })))));
  }))))));
};
exports.NumeralDate = NumeralDate;
var _default = exports.default = NumeralDate;