"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StyledTitle = exports.StyledNoteMain = exports.StyledNoteContent = exports.StyledNote = exports.StyledInlineControl = exports.StyledFooterContent = exports.StyledFooter = void 0;
var _styledComponents = _interopRequireWildcard(require("styled-components"));
var _styledSystem = require("styled-system");
var _base = _interopRequireDefault(require("../../style/themes/base"));
var _linkPreview = require("../link-preview/link-preview.style");
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const StyledNoteContent = exports.StyledNoteContent = _styledComponents.default.div`
  position: relative;
  width: 100%;

  ${({
  hasPreview
}) => (0, _styledComponents.css)`
    div.DraftEditor-root {
      min-height: inherit;
      height: 100%;
    }

    div.DraftEditor-editorContainer,
    div.public-DraftEditor-content {
      min-height: inherit;
      height: 100%;
      background-color: var(--colorsUtilityYang100);
      line-height: 21px;
    }

    &:last-of-type:not(:first-of-type) {
      border-top: solid 1px var(--colorsUtilityMajor050);
    }

    ${hasPreview && `
      margin-top: var(--spacing200);
    `}
  `}
`;
const StyledNoteMain = exports.StyledNoteMain = _styledComponents.default.div`
  display: flex;
  justify-content: space-between;
  padding-bottom: var(--spacing300);
`;
const StyledInlineControl = exports.StyledInlineControl = _styledComponents.default.div`
  display: inline-block;
  min-width: fit-content;
`;
const StyledTitle = exports.StyledTitle = _styledComponents.default.header`
  font-weight: 900;
  font-size: 16px;
  line-height: 21px;
  padding-bottom: 16px;
`;
const StyledFooterContent = exports.StyledFooterContent = _styledComponents.default.div`
  line-height: 21px;
  align-items: baseline;
  font-weight: bold;

  ${({
  hasName
}) => (0, _styledComponents.css)`
    margin-top: var(--spacing200);

    ${hasName && (0, _styledComponents.css)`
      &:first-of-type {
        font-size: 14px;
      }

      &:nth-of-type(2) {
        font-size: 12px;
        color: var(--colorsUtilityYin065);
        margin-left: var(--spacing200);
      }

      &:last-of-type:not(:nth-of-type(2)) {
        font-size: 12px;
        color: var(--colorsUtilityYin065);
        cursor: pointer;
        margin-left: var(--spacing300);
      }
    `}

    ${!hasName && (0, _styledComponents.css)`
      &:first-of-type {
        font-size: 12px;
        color: var(--colorsUtilityYin065);
      }

      &:last-of-type:not(:first-of-type) {
        font-size: 12px;
        color: var(--colorsUtilityYin065);
        cursor: pointer;
        margin-left: var(--spacing300);
      }
    `}
  `}
`;
const StyledFooter = exports.StyledFooter = _styledComponents.default.div`
  display: flex;
  margin-bottom: calc(-1 * var(--spacing100));
  flex-wrap: wrap;
`;
const StyledNote = exports.StyledNote = _styledComponents.default.div`
  ${({
  width
}) => (0, _styledComponents.css)`
    background-color: var(--colorsUtilityYang100);
    border: 1px solid var(--colorsUtilityMajor100);
    border-radius: var(--borderRadius100);
    display: flex;
    flex-direction: column;
    padding: 24px;
    position: relative;
    width: ${width}%;
    box-sizing: border-box;

    ${StyledNoteContent} {
      box-sizing: border-box;
      width: auto;
    }
  `}

  ${_linkPreview.StyledLinkPreview} {
    margin: 0px;

    :not(:first-of-type) {
      margin-top: 8px;
    }
  }

  ${_styledSystem.margin}
`;
StyledNote.defaultProps = {
  theme: _base.default
};