"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.Note = void 0;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _draftJs = require("draft-js");
var _invariant = _interopRequireDefault(require("invariant"));
var _note = require("./note.style");
var _statusIcon = _interopRequireDefault(require("./__internal__/status-icon"));
var _actionPopover = require("../action-popover");
var _utils = require("../text-editor/__internal__/utils");
var _textEditor = require("../text-editor/text-editor.component");
var _linkPreview = _interopRequireDefault(require("../link-preview"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
function hasExpectedDisplayName(child, displayName) {
  return child.type.displayName === displayName;
}
const Note = ({
  createdDate,
  inlineControl,
  name,
  noteContent,
  onLinkAdded,
  previews,
  status,
  title,
  width = 100,
  ...rest
}) => {
  !(width > 0) ? process.env.NODE_ENV !== "production" ? (0, _invariant.default)(false, "<Note> width must be greater than 0") : (0, _invariant.default)(false) : void 0;
  !createdDate ? process.env.NODE_ENV !== "production" ? (0, _invariant.default)(false, "<Note> createdDate is required") : (0, _invariant.default)(false) : void 0;
  !noteContent ? process.env.NODE_ENV !== "production" ? (0, _invariant.default)(false, "<Note> noteContent is required") : (0, _invariant.default)(false) : void 0;
  !(!status || status.text) ? process.env.NODE_ENV !== "production" ? (0, _invariant.default)(false, "<Note> status.text is required") : (0, _invariant.default)(false) : void 0;
  !(!status || status.timeStamp) ? process.env.NODE_ENV !== "production" ? (0, _invariant.default)(false, "<Note> status.timeStamp is required") : (0, _invariant.default)(false) : void 0;
  !(!inlineControl || /*#__PURE__*/_react.default.isValidElement(inlineControl) && inlineControl.type === _actionPopover.ActionPopover) ? process.env.NODE_ENV !== "production" ? (0, _invariant.default)(false, "<Note> inlineControl must be an instance of <ActionPopover>") : (0, _invariant.default)(false) : void 0;
  const renderStatus = () => {
    if (!status) {
      return null;
    }
    const {
      text,
      timeStamp
    } = status;
    return /*#__PURE__*/_react.default.createElement(_note.StyledFooterContent, {
      hasName: !!name,
      "data-component": "note-status"
    }, /*#__PURE__*/_react.default.createElement(_statusIcon.default, {
      tooltipMessage: timeStamp
    }, text));
  };
  return /*#__PURE__*/_react.default.createElement(_textEditor.EditorContext.Provider, {
    value: {
      onLinkAdded,
      editMode: false
    }
  }, /*#__PURE__*/_react.default.createElement(_note.StyledNote, _extends({
    width: width
  }, rest, {
    "data-component": "note"
  }), /*#__PURE__*/_react.default.createElement(_note.StyledNoteMain, null, /*#__PURE__*/_react.default.createElement(_note.StyledNoteContent, null, title && /*#__PURE__*/_react.default.createElement(_note.StyledTitle, null, title), /*#__PURE__*/_react.default.createElement(_draftJs.Editor, {
    readOnly: true,
    editorState: (0, _utils.getDecoratedValue)(noteContent),
    onChange: /* istanbul ignore next */() => {}
  })), inlineControl && /*#__PURE__*/_react.default.createElement(_note.StyledInlineControl, null, inlineControl)), /*#__PURE__*/_react.default.createElement(_note.StyledNoteContent, null, _react.default.Children.map(previews, preview => /*#__PURE__*/_react.default.isValidElement(preview) && hasExpectedDisplayName(preview, _linkPreview.default.displayName) ? /*#__PURE__*/_react.default.cloneElement(preview, {
    as: "a",
    onClose: undefined
  }) : preview)), createdDate && /*#__PURE__*/_react.default.createElement(_note.StyledNoteContent, {
    hasPreview: !!_react.default.Children.count(previews)
  }, /*#__PURE__*/_react.default.createElement(_note.StyledFooter, {
    "data-element": "note-footer"
  }, name && /*#__PURE__*/_react.default.createElement(_note.StyledFooterContent, {
    hasName: !!name
  }, name), /*#__PURE__*/_react.default.createElement(_note.StyledFooterContent, {
    hasName: !!name
  }, createdDate), renderStatus()))));
};
exports.Note = Note;
var _default = exports.default = Note;