import React from "react";
import { EditorState } from "draft-js";
import { MarginProps } from "styled-system";
export interface NoteProps extends MarginProps {
    /** Adds a created on date to the Note footer */
    createdDate: string;
    /** renders a control for the Note */
    inlineControl?: React.ReactNode;
    /** Adds a name to the Note footer */
    name?: string;
    /**  The rich text content to display in the Note */
    noteContent: EditorState;
    /** Callback to report a url when a link is added */
    onLinkAdded?: (url: string) => void;
    /** The previews to display of any links added to the Editor */
    previews?: React.ReactNode;
    /** Adds a status and tooltip to the Note footer */
    status?: {
        text: string;
        timeStamp: string;
    };
    /** Adds a Title to the Note */
    title?: string;
    /** Set a percentage-based width for the whole Note component, relative to its parent. */
    width?: number;
}
export declare const Note: ({ createdDate, inlineControl, name, noteContent, onLinkAdded, previews, status, title, width, ...rest }: NoteProps) => React.JSX.Element;
export default Note;
