"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _statusIcon = _interopRequireDefault(require("./status-icon.style"));
var _tooltip = _interopRequireDefault(require("../../../tooltip"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
const StatusIcon = /*#__PURE__*/_react.default.forwardRef(({
  tooltipMessage,
  children
}, ref) => {
  return /*#__PURE__*/_react.default.createElement(_tooltip.default, {
    message: tooltipMessage
  }, /*#__PURE__*/_react.default.createElement(_statusIcon.default, {
    "data-component": "status-with-tooltip",
    ref: ref
  }, children));
});
if (process.env.NODE_ENV !== "production") {
  StatusIcon.propTypes = {
    "children": _propTypes.default.node,
    "tooltipMessage": _propTypes.default.string.isRequired
  };
}
StatusIcon.displayName = "StatusIcon";
var _default = exports.default = StatusIcon;