"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _styledComponents = _interopRequireWildcard(require("styled-components"));
var _styledSystem = require("styled-system");
var _themes = require("../../style/themes");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const StyledNavigationBar = _styledComponents.default.nav`
  display: flex;
  align-items: center;
  padding: 0 40px;
  line-height: 40px;

  & > * {
    box-sizing: border-box;
    height: 40px;
    vertical-align: middle;
  }

  @media only screen and (max-width: 1259px) {
    padding: 0 32px;
  }

  @media only screen and (max-width: 959px) {
    padding: 0 24px;
  }

  @media only screen and (max-width: 599px) {
    padding: 0 16px;
  }

  && {
    ${_styledSystem.padding}
  }

  ${_styledSystem.flexbox}

  .carbon-logo {
    margin-right: 10px;
  }

  ${({
  position,
  orientation,
  offset
}) => position && orientation && (0, _styledComponents.css)`
      position: ${position};
      ${orientation}: ${offset};

      ${position === "fixed" && (0, _styledComponents.css)`
        box-sizing: border-box;
        width: 100%;
      `}
    `}

  ${({
  navigationType,
  theme,
  isGlobal
}) => (0, _styledComponents.css)`
    min-height: 40px;
    z-index: ${isGlobal ? theme.zIndex.globalNav : theme.zIndex.nav};

    ${navigationType === "light" && (0, _styledComponents.css)`
      background-color: var(--colorsComponentsMenuSpringStandard500);
      border-bottom: var(--borderWidth100) solid
        var(--colorsComponentsMenuSpringChildAlt500);
    `}

    ${navigationType === "dark" && (0, _styledComponents.css)`
      background-color: var(--colorsComponentsMenuAutumnStandard500);
      color: var(--colorsComponentsMenuYang100);
    `}

    ${navigationType === "black" && (0, _styledComponents.css)`
      background-color: var(--colorsComponentsMenuWinterStandard500);
      color: var(--colorsComponentsMenuYang100);
    `}

    ${navigationType === "white" && (0, _styledComponents.css)`
      background-color: var(--colorsComponentsMenuSummerStandard500);
      border-bottom: var(--borderWidth100) solid
        var(--colorsComponentsMenuSummerChildAlt500);
    `}
  `}
`;
StyledNavigationBar.defaultProps = {
  theme: _themes.baseTheme
};
var _default = exports.default = StyledNavigationBar;