"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.NavigationBar = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _navigationBar = _interopRequireDefault(require("./navigation-bar.style"));
var _fixedNavigationBar = require("./fixed-navigation-bar.context");
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
const NavigationBar = ({
  navigationType = "light",
  isLoading = false,
  children,
  ariaLabel,
  position,
  offset = "0px",
  orientation,
  isGlobal,
  ...props
}) => {
  const navbarRef = (0, _react.useRef)(null);
  return /*#__PURE__*/_react.default.createElement(_fixedNavigationBar.FixedNavigationBarContextProvider, {
    orientation: isGlobal ? "top" : orientation,
    offset: isGlobal ? "0px" : offset,
    position: isGlobal ? "fixed" : position,
    navbarRef: navbarRef
  }, /*#__PURE__*/_react.default.createElement(_navigationBar.default, _extends({
    role: "navigation",
    "data-component": isGlobal ? "global-header" : "navigation-bar",
    "aria-label": isGlobal ? "Global Header" : ariaLabel,
    navigationType: isGlobal ? "black" : navigationType,
    orientation: isGlobal ? "top" : orientation,
    offset: isGlobal ? "0px" : offset,
    position: isGlobal ? "fixed" : position
  }, props, {
    isGlobal: isGlobal,
    ref: navbarRef
  }), !isLoading && children));
};
exports.NavigationBar = NavigationBar;
if (process.env.NODE_ENV !== "production") {
  NavigationBar.propTypes = {
    "alignContent": _propTypes.default.oneOfType([_propTypes.default.oneOf(["-moz-initial", "baseline", "center", "end", "flex-end", "flex-start", "inherit", "initial", "normal", "revert-layer", "revert", "space-around", "space-between", "space-evenly", "start", "stretch", "unset"]), _propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf(["-moz-initial", "baseline", "center", "end", "flex-end", "flex-start", "inherit", "initial", "normal", "revert-layer", "revert", "space-around", "space-between", "space-evenly", "start", "stretch", "unset", null]), _propTypes.default.shape({
      "__@iterator": _propTypes.default.func.isRequired,
      "anchor": _propTypes.default.func.isRequired,
      "at": _propTypes.default.func.isRequired,
      "big": _propTypes.default.func.isRequired,
      "blink": _propTypes.default.func.isRequired,
      "bold": _propTypes.default.func.isRequired,
      "charAt": _propTypes.default.func.isRequired,
      "charCodeAt": _propTypes.default.func.isRequired,
      "codePointAt": _propTypes.default.func.isRequired,
      "concat": _propTypes.default.func.isRequired,
      "endsWith": _propTypes.default.func.isRequired,
      "fixed": _propTypes.default.func.isRequired,
      "fontcolor": _propTypes.default.func.isRequired,
      "fontsize": _propTypes.default.func.isRequired,
      "includes": _propTypes.default.func.isRequired,
      "indexOf": _propTypes.default.func.isRequired,
      "italics": _propTypes.default.func.isRequired,
      "lastIndexOf": _propTypes.default.func.isRequired,
      "length": _propTypes.default.number.isRequired,
      "link": _propTypes.default.func.isRequired,
      "localeCompare": _propTypes.default.func.isRequired,
      "match": _propTypes.default.func.isRequired,
      "matchAll": _propTypes.default.func.isRequired,
      "normalize": _propTypes.default.func.isRequired,
      "padEnd": _propTypes.default.func.isRequired,
      "padStart": _propTypes.default.func.isRequired,
      "repeat": _propTypes.default.func.isRequired,
      "replace": _propTypes.default.func.isRequired,
      "search": _propTypes.default.func.isRequired,
      "slice": _propTypes.default.func.isRequired,
      "small": _propTypes.default.func.isRequired,
      "split": _propTypes.default.func.isRequired,
      "startsWith": _propTypes.default.func.isRequired,
      "strike": _propTypes.default.func.isRequired,
      "sub": _propTypes.default.func.isRequired,
      "substr": _propTypes.default.func.isRequired,
      "substring": _propTypes.default.func.isRequired,
      "sup": _propTypes.default.func.isRequired,
      "toLocaleLowerCase": _propTypes.default.func.isRequired,
      "toLocaleUpperCase": _propTypes.default.func.isRequired,
      "toLowerCase": _propTypes.default.func.isRequired,
      "toString": _propTypes.default.func.isRequired,
      "toUpperCase": _propTypes.default.func.isRequired,
      "trim": _propTypes.default.func.isRequired,
      "trimEnd": _propTypes.default.func.isRequired,
      "trimLeft": _propTypes.default.func.isRequired,
      "trimRight": _propTypes.default.func.isRequired,
      "trimStart": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    })])), _propTypes.default.object, _propTypes.default.shape({
      "__@iterator": _propTypes.default.func.isRequired,
      "anchor": _propTypes.default.func.isRequired,
      "at": _propTypes.default.func.isRequired,
      "big": _propTypes.default.func.isRequired,
      "blink": _propTypes.default.func.isRequired,
      "bold": _propTypes.default.func.isRequired,
      "charAt": _propTypes.default.func.isRequired,
      "charCodeAt": _propTypes.default.func.isRequired,
      "codePointAt": _propTypes.default.func.isRequired,
      "concat": _propTypes.default.func.isRequired,
      "endsWith": _propTypes.default.func.isRequired,
      "fixed": _propTypes.default.func.isRequired,
      "fontcolor": _propTypes.default.func.isRequired,
      "fontsize": _propTypes.default.func.isRequired,
      "includes": _propTypes.default.func.isRequired,
      "indexOf": _propTypes.default.func.isRequired,
      "italics": _propTypes.default.func.isRequired,
      "lastIndexOf": _propTypes.default.func.isRequired,
      "length": _propTypes.default.number.isRequired,
      "link": _propTypes.default.func.isRequired,
      "localeCompare": _propTypes.default.func.isRequired,
      "match": _propTypes.default.func.isRequired,
      "matchAll": _propTypes.default.func.isRequired,
      "normalize": _propTypes.default.func.isRequired,
      "padEnd": _propTypes.default.func.isRequired,
      "padStart": _propTypes.default.func.isRequired,
      "repeat": _propTypes.default.func.isRequired,
      "replace": _propTypes.default.func.isRequired,
      "search": _propTypes.default.func.isRequired,
      "slice": _propTypes.default.func.isRequired,
      "small": _propTypes.default.func.isRequired,
      "split": _propTypes.default.func.isRequired,
      "startsWith": _propTypes.default.func.isRequired,
      "strike": _propTypes.default.func.isRequired,
      "sub": _propTypes.default.func.isRequired,
      "substr": _propTypes.default.func.isRequired,
      "substring": _propTypes.default.func.isRequired,
      "sup": _propTypes.default.func.isRequired,
      "toLocaleLowerCase": _propTypes.default.func.isRequired,
      "toLocaleUpperCase": _propTypes.default.func.isRequired,
      "toLowerCase": _propTypes.default.func.isRequired,
      "toString": _propTypes.default.func.isRequired,
      "toUpperCase": _propTypes.default.func.isRequired,
      "trim": _propTypes.default.func.isRequired,
      "trimEnd": _propTypes.default.func.isRequired,
      "trimLeft": _propTypes.default.func.isRequired,
      "trimRight": _propTypes.default.func.isRequired,
      "trimStart": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    })]),
    "alignItems": _propTypes.default.oneOfType([_propTypes.default.oneOf(["-moz-initial", "baseline", "center", "end", "flex-end", "flex-start", "inherit", "initial", "normal", "revert-layer", "revert", "self-end", "self-start", "start", "stretch", "unset"]), _propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf(["-moz-initial", "baseline", "center", "end", "flex-end", "flex-start", "inherit", "initial", "normal", "revert-layer", "revert", "self-end", "self-start", "start", "stretch", "unset", null]), _propTypes.default.shape({
      "__@iterator": _propTypes.default.func.isRequired,
      "anchor": _propTypes.default.func.isRequired,
      "at": _propTypes.default.func.isRequired,
      "big": _propTypes.default.func.isRequired,
      "blink": _propTypes.default.func.isRequired,
      "bold": _propTypes.default.func.isRequired,
      "charAt": _propTypes.default.func.isRequired,
      "charCodeAt": _propTypes.default.func.isRequired,
      "codePointAt": _propTypes.default.func.isRequired,
      "concat": _propTypes.default.func.isRequired,
      "endsWith": _propTypes.default.func.isRequired,
      "fixed": _propTypes.default.func.isRequired,
      "fontcolor": _propTypes.default.func.isRequired,
      "fontsize": _propTypes.default.func.isRequired,
      "includes": _propTypes.default.func.isRequired,
      "indexOf": _propTypes.default.func.isRequired,
      "italics": _propTypes.default.func.isRequired,
      "lastIndexOf": _propTypes.default.func.isRequired,
      "length": _propTypes.default.number.isRequired,
      "link": _propTypes.default.func.isRequired,
      "localeCompare": _propTypes.default.func.isRequired,
      "match": _propTypes.default.func.isRequired,
      "matchAll": _propTypes.default.func.isRequired,
      "normalize": _propTypes.default.func.isRequired,
      "padEnd": _propTypes.default.func.isRequired,
      "padStart": _propTypes.default.func.isRequired,
      "repeat": _propTypes.default.func.isRequired,
      "replace": _propTypes.default.func.isRequired,
      "search": _propTypes.default.func.isRequired,
      "slice": _propTypes.default.func.isRequired,
      "small": _propTypes.default.func.isRequired,
      "split": _propTypes.default.func.isRequired,
      "startsWith": _propTypes.default.func.isRequired,
      "strike": _propTypes.default.func.isRequired,
      "sub": _propTypes.default.func.isRequired,
      "substr": _propTypes.default.func.isRequired,
      "substring": _propTypes.default.func.isRequired,
      "sup": _propTypes.default.func.isRequired,
      "toLocaleLowerCase": _propTypes.default.func.isRequired,
      "toLocaleUpperCase": _propTypes.default.func.isRequired,
      "toLowerCase": _propTypes.default.func.isRequired,
      "toString": _propTypes.default.func.isRequired,
      "toUpperCase": _propTypes.default.func.isRequired,
      "trim": _propTypes.default.func.isRequired,
      "trimEnd": _propTypes.default.func.isRequired,
      "trimLeft": _propTypes.default.func.isRequired,
      "trimRight": _propTypes.default.func.isRequired,
      "trimStart": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    })])), _propTypes.default.object, _propTypes.default.shape({
      "__@iterator": _propTypes.default.func.isRequired,
      "anchor": _propTypes.default.func.isRequired,
      "at": _propTypes.default.func.isRequired,
      "big": _propTypes.default.func.isRequired,
      "blink": _propTypes.default.func.isRequired,
      "bold": _propTypes.default.func.isRequired,
      "charAt": _propTypes.default.func.isRequired,
      "charCodeAt": _propTypes.default.func.isRequired,
      "codePointAt": _propTypes.default.func.isRequired,
      "concat": _propTypes.default.func.isRequired,
      "endsWith": _propTypes.default.func.isRequired,
      "fixed": _propTypes.default.func.isRequired,
      "fontcolor": _propTypes.default.func.isRequired,
      "fontsize": _propTypes.default.func.isRequired,
      "includes": _propTypes.default.func.isRequired,
      "indexOf": _propTypes.default.func.isRequired,
      "italics": _propTypes.default.func.isRequired,
      "lastIndexOf": _propTypes.default.func.isRequired,
      "length": _propTypes.default.number.isRequired,
      "link": _propTypes.default.func.isRequired,
      "localeCompare": _propTypes.default.func.isRequired,
      "match": _propTypes.default.func.isRequired,
      "matchAll": _propTypes.default.func.isRequired,
      "normalize": _propTypes.default.func.isRequired,
      "padEnd": _propTypes.default.func.isRequired,
      "padStart": _propTypes.default.func.isRequired,
      "repeat": _propTypes.default.func.isRequired,
      "replace": _propTypes.default.func.isRequired,
      "search": _propTypes.default.func.isRequired,
      "slice": _propTypes.default.func.isRequired,
      "small": _propTypes.default.func.isRequired,
      "split": _propTypes.default.func.isRequired,
      "startsWith": _propTypes.default.func.isRequired,
      "strike": _propTypes.default.func.isRequired,
      "sub": _propTypes.default.func.isRequired,
      "substr": _propTypes.default.func.isRequired,
      "substring": _propTypes.default.func.isRequired,
      "sup": _propTypes.default.func.isRequired,
      "toLocaleLowerCase": _propTypes.default.func.isRequired,
      "toLocaleUpperCase": _propTypes.default.func.isRequired,
      "toLowerCase": _propTypes.default.func.isRequired,
      "toString": _propTypes.default.func.isRequired,
      "toUpperCase": _propTypes.default.func.isRequired,
      "trim": _propTypes.default.func.isRequired,
      "trimEnd": _propTypes.default.func.isRequired,
      "trimLeft": _propTypes.default.func.isRequired,
      "trimRight": _propTypes.default.func.isRequired,
      "trimStart": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    })]),
    "alignSelf": _propTypes.default.oneOfType([_propTypes.default.oneOf(["-moz-initial", "auto", "baseline", "center", "end", "flex-end", "flex-start", "inherit", "initial", "normal", "revert-layer", "revert", "self-end", "self-start", "start", "stretch", "unset"]), _propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf(["-moz-initial", "auto", "baseline", "center", "end", "flex-end", "flex-start", "inherit", "initial", "normal", "revert-layer", "revert", "self-end", "self-start", "start", "stretch", "unset", null]), _propTypes.default.shape({
      "__@iterator": _propTypes.default.func.isRequired,
      "anchor": _propTypes.default.func.isRequired,
      "at": _propTypes.default.func.isRequired,
      "big": _propTypes.default.func.isRequired,
      "blink": _propTypes.default.func.isRequired,
      "bold": _propTypes.default.func.isRequired,
      "charAt": _propTypes.default.func.isRequired,
      "charCodeAt": _propTypes.default.func.isRequired,
      "codePointAt": _propTypes.default.func.isRequired,
      "concat": _propTypes.default.func.isRequired,
      "endsWith": _propTypes.default.func.isRequired,
      "fixed": _propTypes.default.func.isRequired,
      "fontcolor": _propTypes.default.func.isRequired,
      "fontsize": _propTypes.default.func.isRequired,
      "includes": _propTypes.default.func.isRequired,
      "indexOf": _propTypes.default.func.isRequired,
      "italics": _propTypes.default.func.isRequired,
      "lastIndexOf": _propTypes.default.func.isRequired,
      "length": _propTypes.default.number.isRequired,
      "link": _propTypes.default.func.isRequired,
      "localeCompare": _propTypes.default.func.isRequired,
      "match": _propTypes.default.func.isRequired,
      "matchAll": _propTypes.default.func.isRequired,
      "normalize": _propTypes.default.func.isRequired,
      "padEnd": _propTypes.default.func.isRequired,
      "padStart": _propTypes.default.func.isRequired,
      "repeat": _propTypes.default.func.isRequired,
      "replace": _propTypes.default.func.isRequired,
      "search": _propTypes.default.func.isRequired,
      "slice": _propTypes.default.func.isRequired,
      "small": _propTypes.default.func.isRequired,
      "split": _propTypes.default.func.isRequired,
      "startsWith": _propTypes.default.func.isRequired,
      "strike": _propTypes.default.func.isRequired,
      "sub": _propTypes.default.func.isRequired,
      "substr": _propTypes.default.func.isRequired,
      "substring": _propTypes.default.func.isRequired,
      "sup": _propTypes.default.func.isRequired,
      "toLocaleLowerCase": _propTypes.default.func.isRequired,
      "toLocaleUpperCase": _propTypes.default.func.isRequired,
      "toLowerCase": _propTypes.default.func.isRequired,
      "toString": _propTypes.default.func.isRequired,
      "toUpperCase": _propTypes.default.func.isRequired,
      "trim": _propTypes.default.func.isRequired,
      "trimEnd": _propTypes.default.func.isRequired,
      "trimLeft": _propTypes.default.func.isRequired,
      "trimRight": _propTypes.default.func.isRequired,
      "trimStart": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    })])), _propTypes.default.object, _propTypes.default.shape({
      "__@iterator": _propTypes.default.func.isRequired,
      "anchor": _propTypes.default.func.isRequired,
      "at": _propTypes.default.func.isRequired,
      "big": _propTypes.default.func.isRequired,
      "blink": _propTypes.default.func.isRequired,
      "bold": _propTypes.default.func.isRequired,
      "charAt": _propTypes.default.func.isRequired,
      "charCodeAt": _propTypes.default.func.isRequired,
      "codePointAt": _propTypes.default.func.isRequired,
      "concat": _propTypes.default.func.isRequired,
      "endsWith": _propTypes.default.func.isRequired,
      "fixed": _propTypes.default.func.isRequired,
      "fontcolor": _propTypes.default.func.isRequired,
      "fontsize": _propTypes.default.func.isRequired,
      "includes": _propTypes.default.func.isRequired,
      "indexOf": _propTypes.default.func.isRequired,
      "italics": _propTypes.default.func.isRequired,
      "lastIndexOf": _propTypes.default.func.isRequired,
      "length": _propTypes.default.number.isRequired,
      "link": _propTypes.default.func.isRequired,
      "localeCompare": _propTypes.default.func.isRequired,
      "match": _propTypes.default.func.isRequired,
      "matchAll": _propTypes.default.func.isRequired,
      "normalize": _propTypes.default.func.isRequired,
      "padEnd": _propTypes.default.func.isRequired,
      "padStart": _propTypes.default.func.isRequired,
      "repeat": _propTypes.default.func.isRequired,
      "replace": _propTypes.default.func.isRequired,
      "search": _propTypes.default.func.isRequired,
      "slice": _propTypes.default.func.isRequired,
      "small": _propTypes.default.func.isRequired,
      "split": _propTypes.default.func.isRequired,
      "startsWith": _propTypes.default.func.isRequired,
      "strike": _propTypes.default.func.isRequired,
      "sub": _propTypes.default.func.isRequired,
      "substr": _propTypes.default.func.isRequired,
      "substring": _propTypes.default.func.isRequired,
      "sup": _propTypes.default.func.isRequired,
      "toLocaleLowerCase": _propTypes.default.func.isRequired,
      "toLocaleUpperCase": _propTypes.default.func.isRequired,
      "toLowerCase": _propTypes.default.func.isRequired,
      "toString": _propTypes.default.func.isRequired,
      "toUpperCase": _propTypes.default.func.isRequired,
      "trim": _propTypes.default.func.isRequired,
      "trimEnd": _propTypes.default.func.isRequired,
      "trimLeft": _propTypes.default.func.isRequired,
      "trimRight": _propTypes.default.func.isRequired,
      "trimStart": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    })]),
    "ariaLabel": _propTypes.default.string,
    "children": _propTypes.default.node,
    "flex": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@iterator": _propTypes.default.func.isRequired,
      "anchor": _propTypes.default.func.isRequired,
      "at": _propTypes.default.func.isRequired,
      "big": _propTypes.default.func.isRequired,
      "blink": _propTypes.default.func.isRequired,
      "bold": _propTypes.default.func.isRequired,
      "charAt": _propTypes.default.func.isRequired,
      "charCodeAt": _propTypes.default.func.isRequired,
      "codePointAt": _propTypes.default.func.isRequired,
      "concat": _propTypes.default.func.isRequired,
      "endsWith": _propTypes.default.func.isRequired,
      "fixed": _propTypes.default.func.isRequired,
      "fontcolor": _propTypes.default.func.isRequired,
      "fontsize": _propTypes.default.func.isRequired,
      "includes": _propTypes.default.func.isRequired,
      "indexOf": _propTypes.default.func.isRequired,
      "italics": _propTypes.default.func.isRequired,
      "lastIndexOf": _propTypes.default.func.isRequired,
      "length": _propTypes.default.number.isRequired,
      "link": _propTypes.default.func.isRequired,
      "localeCompare": _propTypes.default.func.isRequired,
      "match": _propTypes.default.func.isRequired,
      "matchAll": _propTypes.default.func.isRequired,
      "normalize": _propTypes.default.func.isRequired,
      "padEnd": _propTypes.default.func.isRequired,
      "padStart": _propTypes.default.func.isRequired,
      "repeat": _propTypes.default.func.isRequired,
      "replace": _propTypes.default.func.isRequired,
      "search": _propTypes.default.func.isRequired,
      "slice": _propTypes.default.func.isRequired,
      "small": _propTypes.default.func.isRequired,
      "split": _propTypes.default.func.isRequired,
      "startsWith": _propTypes.default.func.isRequired,
      "strike": _propTypes.default.func.isRequired,
      "sub": _propTypes.default.func.isRequired,
      "substr": _propTypes.default.func.isRequired,
      "substring": _propTypes.default.func.isRequired,
      "sup": _propTypes.default.func.isRequired,
      "toLocaleLowerCase": _propTypes.default.func.isRequired,
      "toLocaleUpperCase": _propTypes.default.func.isRequired,
      "toLowerCase": _propTypes.default.func.isRequired,
      "toString": _propTypes.default.func.isRequired,
      "toUpperCase": _propTypes.default.func.isRequired,
      "trim": _propTypes.default.func.isRequired,
      "trimEnd": _propTypes.default.func.isRequired,
      "trimLeft": _propTypes.default.func.isRequired,
      "trimRight": _propTypes.default.func.isRequired,
      "trimStart": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@iterator": _propTypes.default.func.isRequired,
      "anchor": _propTypes.default.func.isRequired,
      "at": _propTypes.default.func.isRequired,
      "big": _propTypes.default.func.isRequired,
      "blink": _propTypes.default.func.isRequired,
      "bold": _propTypes.default.func.isRequired,
      "charAt": _propTypes.default.func.isRequired,
      "charCodeAt": _propTypes.default.func.isRequired,
      "codePointAt": _propTypes.default.func.isRequired,
      "concat": _propTypes.default.func.isRequired,
      "endsWith": _propTypes.default.func.isRequired,
      "fixed": _propTypes.default.func.isRequired,
      "fontcolor": _propTypes.default.func.isRequired,
      "fontsize": _propTypes.default.func.isRequired,
      "includes": _propTypes.default.func.isRequired,
      "indexOf": _propTypes.default.func.isRequired,
      "italics": _propTypes.default.func.isRequired,
      "lastIndexOf": _propTypes.default.func.isRequired,
      "length": _propTypes.default.number.isRequired,
      "link": _propTypes.default.func.isRequired,
      "localeCompare": _propTypes.default.func.isRequired,
      "match": _propTypes.default.func.isRequired,
      "matchAll": _propTypes.default.func.isRequired,
      "normalize": _propTypes.default.func.isRequired,
      "padEnd": _propTypes.default.func.isRequired,
      "padStart": _propTypes.default.func.isRequired,
      "repeat": _propTypes.default.func.isRequired,
      "replace": _propTypes.default.func.isRequired,
      "search": _propTypes.default.func.isRequired,
      "slice": _propTypes.default.func.isRequired,
      "small": _propTypes.default.func.isRequired,
      "split": _propTypes.default.func.isRequired,
      "startsWith": _propTypes.default.func.isRequired,
      "strike": _propTypes.default.func.isRequired,
      "sub": _propTypes.default.func.isRequired,
      "substr": _propTypes.default.func.isRequired,
      "substring": _propTypes.default.func.isRequired,
      "sup": _propTypes.default.func.isRequired,
      "toLocaleLowerCase": _propTypes.default.func.isRequired,
      "toLocaleUpperCase": _propTypes.default.func.isRequired,
      "toLowerCase": _propTypes.default.func.isRequired,
      "toString": _propTypes.default.func.isRequired,
      "toUpperCase": _propTypes.default.func.isRequired,
      "trim": _propTypes.default.func.isRequired,
      "trimEnd": _propTypes.default.func.isRequired,
      "trimLeft": _propTypes.default.func.isRequired,
      "trimRight": _propTypes.default.func.isRequired,
      "trimStart": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string]),
    "flexBasis": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@iterator": _propTypes.default.func.isRequired,
      "anchor": _propTypes.default.func.isRequired,
      "at": _propTypes.default.func.isRequired,
      "big": _propTypes.default.func.isRequired,
      "blink": _propTypes.default.func.isRequired,
      "bold": _propTypes.default.func.isRequired,
      "charAt": _propTypes.default.func.isRequired,
      "charCodeAt": _propTypes.default.func.isRequired,
      "codePointAt": _propTypes.default.func.isRequired,
      "concat": _propTypes.default.func.isRequired,
      "endsWith": _propTypes.default.func.isRequired,
      "fixed": _propTypes.default.func.isRequired,
      "fontcolor": _propTypes.default.func.isRequired,
      "fontsize": _propTypes.default.func.isRequired,
      "includes": _propTypes.default.func.isRequired,
      "indexOf": _propTypes.default.func.isRequired,
      "italics": _propTypes.default.func.isRequired,
      "lastIndexOf": _propTypes.default.func.isRequired,
      "length": _propTypes.default.number.isRequired,
      "link": _propTypes.default.func.isRequired,
      "localeCompare": _propTypes.default.func.isRequired,
      "match": _propTypes.default.func.isRequired,
      "matchAll": _propTypes.default.func.isRequired,
      "normalize": _propTypes.default.func.isRequired,
      "padEnd": _propTypes.default.func.isRequired,
      "padStart": _propTypes.default.func.isRequired,
      "repeat": _propTypes.default.func.isRequired,
      "replace": _propTypes.default.func.isRequired,
      "search": _propTypes.default.func.isRequired,
      "slice": _propTypes.default.func.isRequired,
      "small": _propTypes.default.func.isRequired,
      "split": _propTypes.default.func.isRequired,
      "startsWith": _propTypes.default.func.isRequired,
      "strike": _propTypes.default.func.isRequired,
      "sub": _propTypes.default.func.isRequired,
      "substr": _propTypes.default.func.isRequired,
      "substring": _propTypes.default.func.isRequired,
      "sup": _propTypes.default.func.isRequired,
      "toLocaleLowerCase": _propTypes.default.func.isRequired,
      "toLocaleUpperCase": _propTypes.default.func.isRequired,
      "toLowerCase": _propTypes.default.func.isRequired,
      "toString": _propTypes.default.func.isRequired,
      "toUpperCase": _propTypes.default.func.isRequired,
      "trim": _propTypes.default.func.isRequired,
      "trimEnd": _propTypes.default.func.isRequired,
      "trimLeft": _propTypes.default.func.isRequired,
      "trimRight": _propTypes.default.func.isRequired,
      "trimStart": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@iterator": _propTypes.default.func.isRequired,
      "anchor": _propTypes.default.func.isRequired,
      "at": _propTypes.default.func.isRequired,
      "big": _propTypes.default.func.isRequired,
      "blink": _propTypes.default.func.isRequired,
      "bold": _propTypes.default.func.isRequired,
      "charAt": _propTypes.default.func.isRequired,
      "charCodeAt": _propTypes.default.func.isRequired,
      "codePointAt": _propTypes.default.func.isRequired,
      "concat": _propTypes.default.func.isRequired,
      "endsWith": _propTypes.default.func.isRequired,
      "fixed": _propTypes.default.func.isRequired,
      "fontcolor": _propTypes.default.func.isRequired,
      "fontsize": _propTypes.default.func.isRequired,
      "includes": _propTypes.default.func.isRequired,
      "indexOf": _propTypes.default.func.isRequired,
      "italics": _propTypes.default.func.isRequired,
      "lastIndexOf": _propTypes.default.func.isRequired,
      "length": _propTypes.default.number.isRequired,
      "link": _propTypes.default.func.isRequired,
      "localeCompare": _propTypes.default.func.isRequired,
      "match": _propTypes.default.func.isRequired,
      "matchAll": _propTypes.default.func.isRequired,
      "normalize": _propTypes.default.func.isRequired,
      "padEnd": _propTypes.default.func.isRequired,
      "padStart": _propTypes.default.func.isRequired,
      "repeat": _propTypes.default.func.isRequired,
      "replace": _propTypes.default.func.isRequired,
      "search": _propTypes.default.func.isRequired,
      "slice": _propTypes.default.func.isRequired,
      "small": _propTypes.default.func.isRequired,
      "split": _propTypes.default.func.isRequired,
      "startsWith": _propTypes.default.func.isRequired,
      "strike": _propTypes.default.func.isRequired,
      "sub": _propTypes.default.func.isRequired,
      "substr": _propTypes.default.func.isRequired,
      "substring": _propTypes.default.func.isRequired,
      "sup": _propTypes.default.func.isRequired,
      "toLocaleLowerCase": _propTypes.default.func.isRequired,
      "toLocaleUpperCase": _propTypes.default.func.isRequired,
      "toLowerCase": _propTypes.default.func.isRequired,
      "toString": _propTypes.default.func.isRequired,
      "toUpperCase": _propTypes.default.func.isRequired,
      "trim": _propTypes.default.func.isRequired,
      "trimEnd": _propTypes.default.func.isRequired,
      "trimLeft": _propTypes.default.func.isRequired,
      "trimRight": _propTypes.default.func.isRequired,
      "trimStart": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string]),
    "flexDirection": _propTypes.default.oneOfType([_propTypes.default.oneOf(["-moz-initial", "column-reverse", "column", "inherit", "initial", "revert-layer", "revert", "row-reverse", "row", "unset"]), _propTypes.default.arrayOf(_propTypes.default.oneOf(["-moz-initial", "column-reverse", "column", "inherit", "initial", "revert-layer", "revert", "row-reverse", "row", "unset", null])), _propTypes.default.object]),
    "flexGrow": _propTypes.default.oneOfType([_propTypes.default.oneOf(["-moz-initial", "inherit", "initial", "revert-layer", "revert", "unset"]), _propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf(["-moz-initial", "inherit", "initial", "revert-layer", "revert", "unset", null]), _propTypes.default.shape({
      "__@iterator": _propTypes.default.func.isRequired,
      "anchor": _propTypes.default.func.isRequired,
      "at": _propTypes.default.func.isRequired,
      "big": _propTypes.default.func.isRequired,
      "blink": _propTypes.default.func.isRequired,
      "bold": _propTypes.default.func.isRequired,
      "charAt": _propTypes.default.func.isRequired,
      "charCodeAt": _propTypes.default.func.isRequired,
      "codePointAt": _propTypes.default.func.isRequired,
      "concat": _propTypes.default.func.isRequired,
      "endsWith": _propTypes.default.func.isRequired,
      "fixed": _propTypes.default.func.isRequired,
      "fontcolor": _propTypes.default.func.isRequired,
      "fontsize": _propTypes.default.func.isRequired,
      "includes": _propTypes.default.func.isRequired,
      "indexOf": _propTypes.default.func.isRequired,
      "italics": _propTypes.default.func.isRequired,
      "lastIndexOf": _propTypes.default.func.isRequired,
      "length": _propTypes.default.number.isRequired,
      "link": _propTypes.default.func.isRequired,
      "localeCompare": _propTypes.default.func.isRequired,
      "match": _propTypes.default.func.isRequired,
      "matchAll": _propTypes.default.func.isRequired,
      "normalize": _propTypes.default.func.isRequired,
      "padEnd": _propTypes.default.func.isRequired,
      "padStart": _propTypes.default.func.isRequired,
      "repeat": _propTypes.default.func.isRequired,
      "replace": _propTypes.default.func.isRequired,
      "search": _propTypes.default.func.isRequired,
      "slice": _propTypes.default.func.isRequired,
      "small": _propTypes.default.func.isRequired,
      "split": _propTypes.default.func.isRequired,
      "startsWith": _propTypes.default.func.isRequired,
      "strike": _propTypes.default.func.isRequired,
      "sub": _propTypes.default.func.isRequired,
      "substr": _propTypes.default.func.isRequired,
      "substring": _propTypes.default.func.isRequired,
      "sup": _propTypes.default.func.isRequired,
      "toLocaleLowerCase": _propTypes.default.func.isRequired,
      "toLocaleUpperCase": _propTypes.default.func.isRequired,
      "toLowerCase": _propTypes.default.func.isRequired,
      "toString": _propTypes.default.func.isRequired,
      "toUpperCase": _propTypes.default.func.isRequired,
      "trim": _propTypes.default.func.isRequired,
      "trimEnd": _propTypes.default.func.isRequired,
      "trimLeft": _propTypes.default.func.isRequired,
      "trimRight": _propTypes.default.func.isRequired,
      "trimStart": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    })])), _propTypes.default.object, _propTypes.default.shape({
      "__@iterator": _propTypes.default.func.isRequired,
      "anchor": _propTypes.default.func.isRequired,
      "at": _propTypes.default.func.isRequired,
      "big": _propTypes.default.func.isRequired,
      "blink": _propTypes.default.func.isRequired,
      "bold": _propTypes.default.func.isRequired,
      "charAt": _propTypes.default.func.isRequired,
      "charCodeAt": _propTypes.default.func.isRequired,
      "codePointAt": _propTypes.default.func.isRequired,
      "concat": _propTypes.default.func.isRequired,
      "endsWith": _propTypes.default.func.isRequired,
      "fixed": _propTypes.default.func.isRequired,
      "fontcolor": _propTypes.default.func.isRequired,
      "fontsize": _propTypes.default.func.isRequired,
      "includes": _propTypes.default.func.isRequired,
      "indexOf": _propTypes.default.func.isRequired,
      "italics": _propTypes.default.func.isRequired,
      "lastIndexOf": _propTypes.default.func.isRequired,
      "length": _propTypes.default.number.isRequired,
      "link": _propTypes.default.func.isRequired,
      "localeCompare": _propTypes.default.func.isRequired,
      "match": _propTypes.default.func.isRequired,
      "matchAll": _propTypes.default.func.isRequired,
      "normalize": _propTypes.default.func.isRequired,
      "padEnd": _propTypes.default.func.isRequired,
      "padStart": _propTypes.default.func.isRequired,
      "repeat": _propTypes.default.func.isRequired,
      "replace": _propTypes.default.func.isRequired,
      "search": _propTypes.default.func.isRequired,
      "slice": _propTypes.default.func.isRequired,
      "small": _propTypes.default.func.isRequired,
      "split": _propTypes.default.func.isRequired,
      "startsWith": _propTypes.default.func.isRequired,
      "strike": _propTypes.default.func.isRequired,
      "sub": _propTypes.default.func.isRequired,
      "substr": _propTypes.default.func.isRequired,
      "substring": _propTypes.default.func.isRequired,
      "sup": _propTypes.default.func.isRequired,
      "toLocaleLowerCase": _propTypes.default.func.isRequired,
      "toLocaleUpperCase": _propTypes.default.func.isRequired,
      "toLowerCase": _propTypes.default.func.isRequired,
      "toString": _propTypes.default.func.isRequired,
      "toUpperCase": _propTypes.default.func.isRequired,
      "trim": _propTypes.default.func.isRequired,
      "trimEnd": _propTypes.default.func.isRequired,
      "trimLeft": _propTypes.default.func.isRequired,
      "trimRight": _propTypes.default.func.isRequired,
      "trimStart": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    })]),
    "flexShrink": _propTypes.default.oneOfType([_propTypes.default.oneOf(["-moz-initial", "inherit", "initial", "revert-layer", "revert", "unset"]), _propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf(["-moz-initial", "inherit", "initial", "revert-layer", "revert", "unset", null]), _propTypes.default.shape({
      "__@iterator": _propTypes.default.func.isRequired,
      "anchor": _propTypes.default.func.isRequired,
      "at": _propTypes.default.func.isRequired,
      "big": _propTypes.default.func.isRequired,
      "blink": _propTypes.default.func.isRequired,
      "bold": _propTypes.default.func.isRequired,
      "charAt": _propTypes.default.func.isRequired,
      "charCodeAt": _propTypes.default.func.isRequired,
      "codePointAt": _propTypes.default.func.isRequired,
      "concat": _propTypes.default.func.isRequired,
      "endsWith": _propTypes.default.func.isRequired,
      "fixed": _propTypes.default.func.isRequired,
      "fontcolor": _propTypes.default.func.isRequired,
      "fontsize": _propTypes.default.func.isRequired,
      "includes": _propTypes.default.func.isRequired,
      "indexOf": _propTypes.default.func.isRequired,
      "italics": _propTypes.default.func.isRequired,
      "lastIndexOf": _propTypes.default.func.isRequired,
      "length": _propTypes.default.number.isRequired,
      "link": _propTypes.default.func.isRequired,
      "localeCompare": _propTypes.default.func.isRequired,
      "match": _propTypes.default.func.isRequired,
      "matchAll": _propTypes.default.func.isRequired,
      "normalize": _propTypes.default.func.isRequired,
      "padEnd": _propTypes.default.func.isRequired,
      "padStart": _propTypes.default.func.isRequired,
      "repeat": _propTypes.default.func.isRequired,
      "replace": _propTypes.default.func.isRequired,
      "search": _propTypes.default.func.isRequired,
      "slice": _propTypes.default.func.isRequired,
      "small": _propTypes.default.func.isRequired,
      "split": _propTypes.default.func.isRequired,
      "startsWith": _propTypes.default.func.isRequired,
      "strike": _propTypes.default.func.isRequired,
      "sub": _propTypes.default.func.isRequired,
      "substr": _propTypes.default.func.isRequired,
      "substring": _propTypes.default.func.isRequired,
      "sup": _propTypes.default.func.isRequired,
      "toLocaleLowerCase": _propTypes.default.func.isRequired,
      "toLocaleUpperCase": _propTypes.default.func.isRequired,
      "toLowerCase": _propTypes.default.func.isRequired,
      "toString": _propTypes.default.func.isRequired,
      "toUpperCase": _propTypes.default.func.isRequired,
      "trim": _propTypes.default.func.isRequired,
      "trimEnd": _propTypes.default.func.isRequired,
      "trimLeft": _propTypes.default.func.isRequired,
      "trimRight": _propTypes.default.func.isRequired,
      "trimStart": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    })])), _propTypes.default.object, _propTypes.default.shape({
      "__@iterator": _propTypes.default.func.isRequired,
      "anchor": _propTypes.default.func.isRequired,
      "at": _propTypes.default.func.isRequired,
      "big": _propTypes.default.func.isRequired,
      "blink": _propTypes.default.func.isRequired,
      "bold": _propTypes.default.func.isRequired,
      "charAt": _propTypes.default.func.isRequired,
      "charCodeAt": _propTypes.default.func.isRequired,
      "codePointAt": _propTypes.default.func.isRequired,
      "concat": _propTypes.default.func.isRequired,
      "endsWith": _propTypes.default.func.isRequired,
      "fixed": _propTypes.default.func.isRequired,
      "fontcolor": _propTypes.default.func.isRequired,
      "fontsize": _propTypes.default.func.isRequired,
      "includes": _propTypes.default.func.isRequired,
      "indexOf": _propTypes.default.func.isRequired,
      "italics": _propTypes.default.func.isRequired,
      "lastIndexOf": _propTypes.default.func.isRequired,
      "length": _propTypes.default.number.isRequired,
      "link": _propTypes.default.func.isRequired,
      "localeCompare": _propTypes.default.func.isRequired,
      "match": _propTypes.default.func.isRequired,
      "matchAll": _propTypes.default.func.isRequired,
      "normalize": _propTypes.default.func.isRequired,
      "padEnd": _propTypes.default.func.isRequired,
      "padStart": _propTypes.default.func.isRequired,
      "repeat": _propTypes.default.func.isRequired,
      "replace": _propTypes.default.func.isRequired,
      "search": _propTypes.default.func.isRequired,
      "slice": _propTypes.default.func.isRequired,
      "small": _propTypes.default.func.isRequired,
      "split": _propTypes.default.func.isRequired,
      "startsWith": _propTypes.default.func.isRequired,
      "strike": _propTypes.default.func.isRequired,
      "sub": _propTypes.default.func.isRequired,
      "substr": _propTypes.default.func.isRequired,
      "substring": _propTypes.default.func.isRequired,
      "sup": _propTypes.default.func.isRequired,
      "toLocaleLowerCase": _propTypes.default.func.isRequired,
      "toLocaleUpperCase": _propTypes.default.func.isRequired,
      "toLowerCase": _propTypes.default.func.isRequired,
      "toString": _propTypes.default.func.isRequired,
      "toUpperCase": _propTypes.default.func.isRequired,
      "trim": _propTypes.default.func.isRequired,
      "trimEnd": _propTypes.default.func.isRequired,
      "trimLeft": _propTypes.default.func.isRequired,
      "trimRight": _propTypes.default.func.isRequired,
      "trimStart": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    })]),
    "flexWrap": _propTypes.default.oneOfType([_propTypes.default.oneOf(["-moz-initial", "inherit", "initial", "nowrap", "revert-layer", "revert", "unset", "wrap-reverse", "wrap"]), _propTypes.default.arrayOf(_propTypes.default.oneOf(["-moz-initial", "inherit", "initial", "nowrap", "revert-layer", "revert", "unset", "wrap-reverse", "wrap", null])), _propTypes.default.object]),
    "isGlobal": _propTypes.default.bool,
    "isLoading": _propTypes.default.bool,
    "justifyContent": _propTypes.default.oneOfType([_propTypes.default.oneOf(["-moz-initial", "center", "end", "flex-end", "flex-start", "inherit", "initial", "left", "normal", "revert-layer", "revert", "right", "space-around", "space-between", "space-evenly", "start", "stretch", "unset"]), _propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf(["-moz-initial", "center", "end", "flex-end", "flex-start", "inherit", "initial", "left", "normal", "revert-layer", "revert", "right", "space-around", "space-between", "space-evenly", "start", "stretch", "unset", null]), _propTypes.default.shape({
      "__@iterator": _propTypes.default.func.isRequired,
      "anchor": _propTypes.default.func.isRequired,
      "at": _propTypes.default.func.isRequired,
      "big": _propTypes.default.func.isRequired,
      "blink": _propTypes.default.func.isRequired,
      "bold": _propTypes.default.func.isRequired,
      "charAt": _propTypes.default.func.isRequired,
      "charCodeAt": _propTypes.default.func.isRequired,
      "codePointAt": _propTypes.default.func.isRequired,
      "concat": _propTypes.default.func.isRequired,
      "endsWith": _propTypes.default.func.isRequired,
      "fixed": _propTypes.default.func.isRequired,
      "fontcolor": _propTypes.default.func.isRequired,
      "fontsize": _propTypes.default.func.isRequired,
      "includes": _propTypes.default.func.isRequired,
      "indexOf": _propTypes.default.func.isRequired,
      "italics": _propTypes.default.func.isRequired,
      "lastIndexOf": _propTypes.default.func.isRequired,
      "length": _propTypes.default.number.isRequired,
      "link": _propTypes.default.func.isRequired,
      "localeCompare": _propTypes.default.func.isRequired,
      "match": _propTypes.default.func.isRequired,
      "matchAll": _propTypes.default.func.isRequired,
      "normalize": _propTypes.default.func.isRequired,
      "padEnd": _propTypes.default.func.isRequired,
      "padStart": _propTypes.default.func.isRequired,
      "repeat": _propTypes.default.func.isRequired,
      "replace": _propTypes.default.func.isRequired,
      "search": _propTypes.default.func.isRequired,
      "slice": _propTypes.default.func.isRequired,
      "small": _propTypes.default.func.isRequired,
      "split": _propTypes.default.func.isRequired,
      "startsWith": _propTypes.default.func.isRequired,
      "strike": _propTypes.default.func.isRequired,
      "sub": _propTypes.default.func.isRequired,
      "substr": _propTypes.default.func.isRequired,
      "substring": _propTypes.default.func.isRequired,
      "sup": _propTypes.default.func.isRequired,
      "toLocaleLowerCase": _propTypes.default.func.isRequired,
      "toLocaleUpperCase": _propTypes.default.func.isRequired,
      "toLowerCase": _propTypes.default.func.isRequired,
      "toString": _propTypes.default.func.isRequired,
      "toUpperCase": _propTypes.default.func.isRequired,
      "trim": _propTypes.default.func.isRequired,
      "trimEnd": _propTypes.default.func.isRequired,
      "trimLeft": _propTypes.default.func.isRequired,
      "trimRight": _propTypes.default.func.isRequired,
      "trimStart": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    })])), _propTypes.default.object, _propTypes.default.shape({
      "__@iterator": _propTypes.default.func.isRequired,
      "anchor": _propTypes.default.func.isRequired,
      "at": _propTypes.default.func.isRequired,
      "big": _propTypes.default.func.isRequired,
      "blink": _propTypes.default.func.isRequired,
      "bold": _propTypes.default.func.isRequired,
      "charAt": _propTypes.default.func.isRequired,
      "charCodeAt": _propTypes.default.func.isRequired,
      "codePointAt": _propTypes.default.func.isRequired,
      "concat": _propTypes.default.func.isRequired,
      "endsWith": _propTypes.default.func.isRequired,
      "fixed": _propTypes.default.func.isRequired,
      "fontcolor": _propTypes.default.func.isRequired,
      "fontsize": _propTypes.default.func.isRequired,
      "includes": _propTypes.default.func.isRequired,
      "indexOf": _propTypes.default.func.isRequired,
      "italics": _propTypes.default.func.isRequired,
      "lastIndexOf": _propTypes.default.func.isRequired,
      "length": _propTypes.default.number.isRequired,
      "link": _propTypes.default.func.isRequired,
      "localeCompare": _propTypes.default.func.isRequired,
      "match": _propTypes.default.func.isRequired,
      "matchAll": _propTypes.default.func.isRequired,
      "normalize": _propTypes.default.func.isRequired,
      "padEnd": _propTypes.default.func.isRequired,
      "padStart": _propTypes.default.func.isRequired,
      "repeat": _propTypes.default.func.isRequired,
      "replace": _propTypes.default.func.isRequired,
      "search": _propTypes.default.func.isRequired,
      "slice": _propTypes.default.func.isRequired,
      "small": _propTypes.default.func.isRequired,
      "split": _propTypes.default.func.isRequired,
      "startsWith": _propTypes.default.func.isRequired,
      "strike": _propTypes.default.func.isRequired,
      "sub": _propTypes.default.func.isRequired,
      "substr": _propTypes.default.func.isRequired,
      "substring": _propTypes.default.func.isRequired,
      "sup": _propTypes.default.func.isRequired,
      "toLocaleLowerCase": _propTypes.default.func.isRequired,
      "toLocaleUpperCase": _propTypes.default.func.isRequired,
      "toLowerCase": _propTypes.default.func.isRequired,
      "toString": _propTypes.default.func.isRequired,
      "toUpperCase": _propTypes.default.func.isRequired,
      "trim": _propTypes.default.func.isRequired,
      "trimEnd": _propTypes.default.func.isRequired,
      "trimLeft": _propTypes.default.func.isRequired,
      "trimRight": _propTypes.default.func.isRequired,
      "trimStart": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    })]),
    "justifyItems": _propTypes.default.oneOfType([_propTypes.default.oneOf(["-moz-initial", "baseline", "center", "end", "flex-end", "flex-start", "inherit", "initial", "left", "legacy", "normal", "revert-layer", "revert", "right", "self-end", "self-start", "start", "stretch", "unset"]), _propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf(["-moz-initial", "baseline", "center", "end", "flex-end", "flex-start", "inherit", "initial", "left", "legacy", "normal", "revert-layer", "revert", "right", "self-end", "self-start", "start", "stretch", "unset", null]), _propTypes.default.shape({
      "__@iterator": _propTypes.default.func.isRequired,
      "anchor": _propTypes.default.func.isRequired,
      "at": _propTypes.default.func.isRequired,
      "big": _propTypes.default.func.isRequired,
      "blink": _propTypes.default.func.isRequired,
      "bold": _propTypes.default.func.isRequired,
      "charAt": _propTypes.default.func.isRequired,
      "charCodeAt": _propTypes.default.func.isRequired,
      "codePointAt": _propTypes.default.func.isRequired,
      "concat": _propTypes.default.func.isRequired,
      "endsWith": _propTypes.default.func.isRequired,
      "fixed": _propTypes.default.func.isRequired,
      "fontcolor": _propTypes.default.func.isRequired,
      "fontsize": _propTypes.default.func.isRequired,
      "includes": _propTypes.default.func.isRequired,
      "indexOf": _propTypes.default.func.isRequired,
      "italics": _propTypes.default.func.isRequired,
      "lastIndexOf": _propTypes.default.func.isRequired,
      "length": _propTypes.default.number.isRequired,
      "link": _propTypes.default.func.isRequired,
      "localeCompare": _propTypes.default.func.isRequired,
      "match": _propTypes.default.func.isRequired,
      "matchAll": _propTypes.default.func.isRequired,
      "normalize": _propTypes.default.func.isRequired,
      "padEnd": _propTypes.default.func.isRequired,
      "padStart": _propTypes.default.func.isRequired,
      "repeat": _propTypes.default.func.isRequired,
      "replace": _propTypes.default.func.isRequired,
      "search": _propTypes.default.func.isRequired,
      "slice": _propTypes.default.func.isRequired,
      "small": _propTypes.default.func.isRequired,
      "split": _propTypes.default.func.isRequired,
      "startsWith": _propTypes.default.func.isRequired,
      "strike": _propTypes.default.func.isRequired,
      "sub": _propTypes.default.func.isRequired,
      "substr": _propTypes.default.func.isRequired,
      "substring": _propTypes.default.func.isRequired,
      "sup": _propTypes.default.func.isRequired,
      "toLocaleLowerCase": _propTypes.default.func.isRequired,
      "toLocaleUpperCase": _propTypes.default.func.isRequired,
      "toLowerCase": _propTypes.default.func.isRequired,
      "toString": _propTypes.default.func.isRequired,
      "toUpperCase": _propTypes.default.func.isRequired,
      "trim": _propTypes.default.func.isRequired,
      "trimEnd": _propTypes.default.func.isRequired,
      "trimLeft": _propTypes.default.func.isRequired,
      "trimRight": _propTypes.default.func.isRequired,
      "trimStart": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    })])), _propTypes.default.object, _propTypes.default.shape({
      "__@iterator": _propTypes.default.func.isRequired,
      "anchor": _propTypes.default.func.isRequired,
      "at": _propTypes.default.func.isRequired,
      "big": _propTypes.default.func.isRequired,
      "blink": _propTypes.default.func.isRequired,
      "bold": _propTypes.default.func.isRequired,
      "charAt": _propTypes.default.func.isRequired,
      "charCodeAt": _propTypes.default.func.isRequired,
      "codePointAt": _propTypes.default.func.isRequired,
      "concat": _propTypes.default.func.isRequired,
      "endsWith": _propTypes.default.func.isRequired,
      "fixed": _propTypes.default.func.isRequired,
      "fontcolor": _propTypes.default.func.isRequired,
      "fontsize": _propTypes.default.func.isRequired,
      "includes": _propTypes.default.func.isRequired,
      "indexOf": _propTypes.default.func.isRequired,
      "italics": _propTypes.default.func.isRequired,
      "lastIndexOf": _propTypes.default.func.isRequired,
      "length": _propTypes.default.number.isRequired,
      "link": _propTypes.default.func.isRequired,
      "localeCompare": _propTypes.default.func.isRequired,
      "match": _propTypes.default.func.isRequired,
      "matchAll": _propTypes.default.func.isRequired,
      "normalize": _propTypes.default.func.isRequired,
      "padEnd": _propTypes.default.func.isRequired,
      "padStart": _propTypes.default.func.isRequired,
      "repeat": _propTypes.default.func.isRequired,
      "replace": _propTypes.default.func.isRequired,
      "search": _propTypes.default.func.isRequired,
      "slice": _propTypes.default.func.isRequired,
      "small": _propTypes.default.func.isRequired,
      "split": _propTypes.default.func.isRequired,
      "startsWith": _propTypes.default.func.isRequired,
      "strike": _propTypes.default.func.isRequired,
      "sub": _propTypes.default.func.isRequired,
      "substr": _propTypes.default.func.isRequired,
      "substring": _propTypes.default.func.isRequired,
      "sup": _propTypes.default.func.isRequired,
      "toLocaleLowerCase": _propTypes.default.func.isRequired,
      "toLocaleUpperCase": _propTypes.default.func.isRequired,
      "toLowerCase": _propTypes.default.func.isRequired,
      "toString": _propTypes.default.func.isRequired,
      "toUpperCase": _propTypes.default.func.isRequired,
      "trim": _propTypes.default.func.isRequired,
      "trimEnd": _propTypes.default.func.isRequired,
      "trimLeft": _propTypes.default.func.isRequired,
      "trimRight": _propTypes.default.func.isRequired,
      "trimStart": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    })]),
    "justifySelf": _propTypes.default.oneOfType([_propTypes.default.oneOf(["-moz-initial", "auto", "baseline", "center", "end", "flex-end", "flex-start", "inherit", "initial", "left", "normal", "revert-layer", "revert", "right", "self-end", "self-start", "start", "stretch", "unset"]), _propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf(["-moz-initial", "auto", "baseline", "center", "end", "flex-end", "flex-start", "inherit", "initial", "left", "normal", "revert-layer", "revert", "right", "self-end", "self-start", "start", "stretch", "unset", null]), _propTypes.default.shape({
      "__@iterator": _propTypes.default.func.isRequired,
      "anchor": _propTypes.default.func.isRequired,
      "at": _propTypes.default.func.isRequired,
      "big": _propTypes.default.func.isRequired,
      "blink": _propTypes.default.func.isRequired,
      "bold": _propTypes.default.func.isRequired,
      "charAt": _propTypes.default.func.isRequired,
      "charCodeAt": _propTypes.default.func.isRequired,
      "codePointAt": _propTypes.default.func.isRequired,
      "concat": _propTypes.default.func.isRequired,
      "endsWith": _propTypes.default.func.isRequired,
      "fixed": _propTypes.default.func.isRequired,
      "fontcolor": _propTypes.default.func.isRequired,
      "fontsize": _propTypes.default.func.isRequired,
      "includes": _propTypes.default.func.isRequired,
      "indexOf": _propTypes.default.func.isRequired,
      "italics": _propTypes.default.func.isRequired,
      "lastIndexOf": _propTypes.default.func.isRequired,
      "length": _propTypes.default.number.isRequired,
      "link": _propTypes.default.func.isRequired,
      "localeCompare": _propTypes.default.func.isRequired,
      "match": _propTypes.default.func.isRequired,
      "matchAll": _propTypes.default.func.isRequired,
      "normalize": _propTypes.default.func.isRequired,
      "padEnd": _propTypes.default.func.isRequired,
      "padStart": _propTypes.default.func.isRequired,
      "repeat": _propTypes.default.func.isRequired,
      "replace": _propTypes.default.func.isRequired,
      "search": _propTypes.default.func.isRequired,
      "slice": _propTypes.default.func.isRequired,
      "small": _propTypes.default.func.isRequired,
      "split": _propTypes.default.func.isRequired,
      "startsWith": _propTypes.default.func.isRequired,
      "strike": _propTypes.default.func.isRequired,
      "sub": _propTypes.default.func.isRequired,
      "substr": _propTypes.default.func.isRequired,
      "substring": _propTypes.default.func.isRequired,
      "sup": _propTypes.default.func.isRequired,
      "toLocaleLowerCase": _propTypes.default.func.isRequired,
      "toLocaleUpperCase": _propTypes.default.func.isRequired,
      "toLowerCase": _propTypes.default.func.isRequired,
      "toString": _propTypes.default.func.isRequired,
      "toUpperCase": _propTypes.default.func.isRequired,
      "trim": _propTypes.default.func.isRequired,
      "trimEnd": _propTypes.default.func.isRequired,
      "trimLeft": _propTypes.default.func.isRequired,
      "trimRight": _propTypes.default.func.isRequired,
      "trimStart": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    })])), _propTypes.default.object, _propTypes.default.shape({
      "__@iterator": _propTypes.default.func.isRequired,
      "anchor": _propTypes.default.func.isRequired,
      "at": _propTypes.default.func.isRequired,
      "big": _propTypes.default.func.isRequired,
      "blink": _propTypes.default.func.isRequired,
      "bold": _propTypes.default.func.isRequired,
      "charAt": _propTypes.default.func.isRequired,
      "charCodeAt": _propTypes.default.func.isRequired,
      "codePointAt": _propTypes.default.func.isRequired,
      "concat": _propTypes.default.func.isRequired,
      "endsWith": _propTypes.default.func.isRequired,
      "fixed": _propTypes.default.func.isRequired,
      "fontcolor": _propTypes.default.func.isRequired,
      "fontsize": _propTypes.default.func.isRequired,
      "includes": _propTypes.default.func.isRequired,
      "indexOf": _propTypes.default.func.isRequired,
      "italics": _propTypes.default.func.isRequired,
      "lastIndexOf": _propTypes.default.func.isRequired,
      "length": _propTypes.default.number.isRequired,
      "link": _propTypes.default.func.isRequired,
      "localeCompare": _propTypes.default.func.isRequired,
      "match": _propTypes.default.func.isRequired,
      "matchAll": _propTypes.default.func.isRequired,
      "normalize": _propTypes.default.func.isRequired,
      "padEnd": _propTypes.default.func.isRequired,
      "padStart": _propTypes.default.func.isRequired,
      "repeat": _propTypes.default.func.isRequired,
      "replace": _propTypes.default.func.isRequired,
      "search": _propTypes.default.func.isRequired,
      "slice": _propTypes.default.func.isRequired,
      "small": _propTypes.default.func.isRequired,
      "split": _propTypes.default.func.isRequired,
      "startsWith": _propTypes.default.func.isRequired,
      "strike": _propTypes.default.func.isRequired,
      "sub": _propTypes.default.func.isRequired,
      "substr": _propTypes.default.func.isRequired,
      "substring": _propTypes.default.func.isRequired,
      "sup": _propTypes.default.func.isRequired,
      "toLocaleLowerCase": _propTypes.default.func.isRequired,
      "toLocaleUpperCase": _propTypes.default.func.isRequired,
      "toLowerCase": _propTypes.default.func.isRequired,
      "toString": _propTypes.default.func.isRequired,
      "toUpperCase": _propTypes.default.func.isRequired,
      "trim": _propTypes.default.func.isRequired,
      "trimEnd": _propTypes.default.func.isRequired,
      "trimLeft": _propTypes.default.func.isRequired,
      "trimRight": _propTypes.default.func.isRequired,
      "trimStart": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    })]),
    "navigationType": _propTypes.default.oneOf(["black", "dark", "light", "white"]),
    "offset": _propTypes.default.string,
    "order": _propTypes.default.oneOfType([_propTypes.default.oneOf(["-moz-initial", "inherit", "initial", "revert-layer", "revert", "unset"]), _propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf(["-moz-initial", "inherit", "initial", "revert-layer", "revert", "unset", null]), _propTypes.default.shape({
      "__@iterator": _propTypes.default.func.isRequired,
      "anchor": _propTypes.default.func.isRequired,
      "at": _propTypes.default.func.isRequired,
      "big": _propTypes.default.func.isRequired,
      "blink": _propTypes.default.func.isRequired,
      "bold": _propTypes.default.func.isRequired,
      "charAt": _propTypes.default.func.isRequired,
      "charCodeAt": _propTypes.default.func.isRequired,
      "codePointAt": _propTypes.default.func.isRequired,
      "concat": _propTypes.default.func.isRequired,
      "endsWith": _propTypes.default.func.isRequired,
      "fixed": _propTypes.default.func.isRequired,
      "fontcolor": _propTypes.default.func.isRequired,
      "fontsize": _propTypes.default.func.isRequired,
      "includes": _propTypes.default.func.isRequired,
      "indexOf": _propTypes.default.func.isRequired,
      "italics": _propTypes.default.func.isRequired,
      "lastIndexOf": _propTypes.default.func.isRequired,
      "length": _propTypes.default.number.isRequired,
      "link": _propTypes.default.func.isRequired,
      "localeCompare": _propTypes.default.func.isRequired,
      "match": _propTypes.default.func.isRequired,
      "matchAll": _propTypes.default.func.isRequired,
      "normalize": _propTypes.default.func.isRequired,
      "padEnd": _propTypes.default.func.isRequired,
      "padStart": _propTypes.default.func.isRequired,
      "repeat": _propTypes.default.func.isRequired,
      "replace": _propTypes.default.func.isRequired,
      "search": _propTypes.default.func.isRequired,
      "slice": _propTypes.default.func.isRequired,
      "small": _propTypes.default.func.isRequired,
      "split": _propTypes.default.func.isRequired,
      "startsWith": _propTypes.default.func.isRequired,
      "strike": _propTypes.default.func.isRequired,
      "sub": _propTypes.default.func.isRequired,
      "substr": _propTypes.default.func.isRequired,
      "substring": _propTypes.default.func.isRequired,
      "sup": _propTypes.default.func.isRequired,
      "toLocaleLowerCase": _propTypes.default.func.isRequired,
      "toLocaleUpperCase": _propTypes.default.func.isRequired,
      "toLowerCase": _propTypes.default.func.isRequired,
      "toString": _propTypes.default.func.isRequired,
      "toUpperCase": _propTypes.default.func.isRequired,
      "trim": _propTypes.default.func.isRequired,
      "trimEnd": _propTypes.default.func.isRequired,
      "trimLeft": _propTypes.default.func.isRequired,
      "trimRight": _propTypes.default.func.isRequired,
      "trimStart": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    })])), _propTypes.default.object, _propTypes.default.shape({
      "__@iterator": _propTypes.default.func.isRequired,
      "anchor": _propTypes.default.func.isRequired,
      "at": _propTypes.default.func.isRequired,
      "big": _propTypes.default.func.isRequired,
      "blink": _propTypes.default.func.isRequired,
      "bold": _propTypes.default.func.isRequired,
      "charAt": _propTypes.default.func.isRequired,
      "charCodeAt": _propTypes.default.func.isRequired,
      "codePointAt": _propTypes.default.func.isRequired,
      "concat": _propTypes.default.func.isRequired,
      "endsWith": _propTypes.default.func.isRequired,
      "fixed": _propTypes.default.func.isRequired,
      "fontcolor": _propTypes.default.func.isRequired,
      "fontsize": _propTypes.default.func.isRequired,
      "includes": _propTypes.default.func.isRequired,
      "indexOf": _propTypes.default.func.isRequired,
      "italics": _propTypes.default.func.isRequired,
      "lastIndexOf": _propTypes.default.func.isRequired,
      "length": _propTypes.default.number.isRequired,
      "link": _propTypes.default.func.isRequired,
      "localeCompare": _propTypes.default.func.isRequired,
      "match": _propTypes.default.func.isRequired,
      "matchAll": _propTypes.default.func.isRequired,
      "normalize": _propTypes.default.func.isRequired,
      "padEnd": _propTypes.default.func.isRequired,
      "padStart": _propTypes.default.func.isRequired,
      "repeat": _propTypes.default.func.isRequired,
      "replace": _propTypes.default.func.isRequired,
      "search": _propTypes.default.func.isRequired,
      "slice": _propTypes.default.func.isRequired,
      "small": _propTypes.default.func.isRequired,
      "split": _propTypes.default.func.isRequired,
      "startsWith": _propTypes.default.func.isRequired,
      "strike": _propTypes.default.func.isRequired,
      "sub": _propTypes.default.func.isRequired,
      "substr": _propTypes.default.func.isRequired,
      "substring": _propTypes.default.func.isRequired,
      "sup": _propTypes.default.func.isRequired,
      "toLocaleLowerCase": _propTypes.default.func.isRequired,
      "toLocaleUpperCase": _propTypes.default.func.isRequired,
      "toLowerCase": _propTypes.default.func.isRequired,
      "toString": _propTypes.default.func.isRequired,
      "toUpperCase": _propTypes.default.func.isRequired,
      "trim": _propTypes.default.func.isRequired,
      "trimEnd": _propTypes.default.func.isRequired,
      "trimLeft": _propTypes.default.func.isRequired,
      "trimRight": _propTypes.default.func.isRequired,
      "trimStart": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    })]),
    "orientation": _propTypes.default.oneOf(["bottom", "top"]),
    "p": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string]),
    "padding": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string]),
    "paddingBottom": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string]),
    "paddingLeft": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string]),
    "paddingRight": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string]),
    "paddingTop": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string]),
    "paddingX": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string]),
    "paddingY": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string]),
    "pb": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string]),
    "pl": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string]),
    "position": _propTypes.default.oneOf(["fixed", "sticky"]),
    "pr": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string]),
    "pt": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string]),
    "px": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string]),
    "py": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])
  };
}
var _default = exports.default = NavigationBar;