"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.FixedNavigationBarContextProvider = void 0;
var _react = _interopRequireWildcard(require("react"));
var _useResizeObserver = _interopRequireDefault(require("../../hooks/__internal__/useResizeObserver/useResizeObserver"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const FixedNavigationBarContext = /*#__PURE__*/(0, _react.createContext)({});
const FixedNavigationBarContextProvider = ({
  position,
  orientation,
  offset,
  children,
  navbarRef
}) => {
  const [navbarHeight, setNavbarHeight] = (0, _react.useState)(navbarRef.current?.offsetHeight);
  const updateHeight = (0, _react.useCallback)(() => setNavbarHeight(navbarRef.current?.offsetHeight), [navbarRef]);
  (0, _react.useEffect)(() => {
    updateHeight();
  }, [updateHeight]);
  (0, _useResizeObserver.default)(navbarRef, updateHeight);
  let submenuMaxHeight;
  if (position === "fixed") {
    if (orientation === "top" && navbarHeight !== undefined) {
      submenuMaxHeight = `calc(100vh - ${navbarHeight}px - ${offset})`;
    } else if (orientation === "bottom") {
      submenuMaxHeight = offset;
    }
  }
  return /*#__PURE__*/_react.default.createElement(FixedNavigationBarContext.Provider, {
    value: {
      submenuMaxHeight
    }
  }, children);
};
exports.FixedNavigationBarContextProvider = FixedNavigationBarContextProvider;
var _default = exports.default = FixedNavigationBarContext;