"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StyledMultiActionButton = exports.StyledButtonChildrenContainer = void 0;
var _styledComponents = _interopRequireWildcard(require("styled-components"));
var _styledSystem = require("styled-system");
var _button = _interopRequireDefault(require("../button/button.style"));
var _base = _interopRequireDefault(require("../../style/themes/base"));
var _icon = _interopRequireDefault(require("../icon/icon.style"));
var _elementSizing = _interopRequireDefault(require("../../style/utils/element-sizing"));
var _splitButtonChildren = require("../split-button/split-button-children.style");
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const StyledMultiActionButton = exports.StyledMultiActionButton = _styledComponents.default.div`
  ${_styledSystem.margin}

  display: inline-block;
  position: relative;

  ${({
  width
}) => width && (0, _styledComponents.css)`
    ${(0, _elementSizing.default)({
  width
})}

    ${_button.default} {
      width: 100%
      justify-content: space-between;
    }`}

  & > ${_button.default} {
    margin: 0;

    ${_icon.default} {
      margin-left: 0;
      left: 8px;
    }

    &:focus {
      background-color: var(--colorsActionMajor700);
      border: 3px solid
        ${({
  theme
}) => !theme.focusRedesignOptOut ? "var(--colorsActionMajor700)" : /* istanbul ignore next */"var(--colorsSemanticFocus500)"};
      outline: none;
      margin: 0 -1px;

      &,
      ${_icon.default} {
        color: var(--colorsActionMajorYang100);
      }
    }

    ${({
  displayed
}) => displayed && (0, _styledComponents.css)`
        background-color: var(--colorsActionMajor700);
        border-color: var(--colorsActionMajor700);

        &,
        ${_icon.default} {
          color: var(--colorsActionMajorYang100);
        }

        &:focus {
          ${({
  theme
}) => /* istanbul ignore next */
theme.focusRedesignOptOut && (0, _styledComponents.css)`
              border-color: var(--colorsSemanticFocus500);
            `}
          margin: 0 -1px;
        }
      `}
  }
`;
const StyledButtonChildrenContainer = exports.StyledButtonChildrenContainer = _styledComponents.default.ul`
  ${({
  theme,
  align,
  minWidth
}) => (0, _styledComponents.css)`
    background-color: var(--colorsActionMajorYang100);
    min-width: ${minWidth}px;
    white-space: nowrap;
    z-index: ${theme.zIndex.popover};
    box-shadow: var(--boxShadow100);
    border-radius: var(--borderRadius100);
    list-style: none;
    padding: 0;
    margin: 0;

    ${_splitButtonChildren.borderRadiusStyling}

    ${_button.default} {
      border: 1px solid var(--colorsActionMajorTransparent);
      display: flex;
      justify-content: ${align};
      margin-left: 0;
      min-width: 100%;
      text-align: ${align};
      z-index: ${theme.zIndex.overlay};

      & + & {
        margin-top: 3px;
      }
    }
  `}
`;
StyledButtonChildrenContainer.defaultProps = {
  theme: _base.default
};
StyledMultiActionButton.defaultProps = {
  theme: _base.default
};