"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.MultiActionButton = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _dom = require("@floating-ui/dom");
var _useClickAwayListener = _interopRequireDefault(require("../../hooks/__internal__/useClickAwayListener"));
var _splitButton = _interopRequireDefault(require("../split-button/__internal__/split-button.context"));
var _multiActionButton = require("./multi-action-button.style");
var _button = _interopRequireDefault(require("../button"));
var _popover = _interopRequireDefault(require("../../__internal__/popover"));
var _utils = require("../../style/utils");
var _useChildButtons = _interopRequireDefault(require("../../hooks/__internal__/useChildButtons"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
const MultiActionButton = ({
  align = "left",
  disabled,
  buttonType,
  size,
  children,
  text,
  subtext,
  width,
  onClick,
  "data-element": dataElement,
  "data-role": dataRole,
  ...rest
}) => {
  const buttonRef = (0, _react.useRef)(null);
  const {
    showAdditionalButtons,
    showButtons,
    hideButtons,
    buttonNode,
    handleToggleButtonKeyDown,
    wrapperProps,
    contextValue
  } = (0, _useChildButtons.default)(buttonRef);
  const handleInsideClick = (0, _useClickAwayListener.default)(hideButtons);
  const handleClick = ev => {
    showButtons();
    handleInsideClick();
    if (onClick) {
      onClick(ev);
    }
  };
  const mainButtonProps = {
    disabled,
    displayed: showAdditionalButtons,
    onTouchStart: showButtons,
    onKeyDown: handleToggleButtonKeyDown,
    onClick: handleClick,
    buttonType,
    size,
    subtext,
    ...(0, _utils.filterOutStyledSystemSpacingProps)(rest)
  };
  const renderAdditionalButtons = () => /*#__PURE__*/_react.default.createElement(_popover.default, {
    placement: "bottom-end",
    reference: buttonNode,
    middleware: [(0, _dom.offset)(6), (0, _dom.flip)({
      fallbackStrategy: "initialPlacement"
    })]
  }, /*#__PURE__*/_react.default.createElement(_multiActionButton.StyledButtonChildrenContainer, _extends({}, wrapperProps, {
    align: align
  }), /*#__PURE__*/_react.default.createElement(_splitButton.default.Provider, {
    value: contextValue
  }, _react.default.Children.map(children, child => /*#__PURE__*/_react.default.createElement("li", null, child)))));
  const marginProps = (0, _utils.filterStyledSystemMarginProps)(rest);
  return /*#__PURE__*/_react.default.createElement(_multiActionButton.StyledMultiActionButton, _extends({
    ref: buttonNode,
    "data-component": "multi-action-button",
    "data-element": dataElement,
    "data-role": dataRole,
    displayed: showAdditionalButtons,
    width: width
  }, marginProps), /*#__PURE__*/_react.default.createElement(_button.default, _extends({
    "aria-haspopup": "true",
    "aria-expanded": showAdditionalButtons,
    "data-element": "toggle-button",
    key: "toggle-button"
  }, mainButtonProps, {
    ref: buttonRef,
    iconPosition: "after",
    iconType: "dropdown"
  }), text), showAdditionalButtons && renderAdditionalButtons());
};
exports.MultiActionButton = MultiActionButton;
var _default = exports.default = MultiActionButton;