"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StyledModalBackground = exports.StyledModal = void 0;
var _styledComponents = _interopRequireWildcard(require("styled-components"));
var _base = _interopRequireDefault(require("../../style/themes/base"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const backgroundOpacity = "0.6";
const StyledModalBackground = exports.StyledModalBackground = _styledComponents.default.div`
  background-color: rgba(0, 20, 29, 1);
  bottom: 0;
  left: 0;
  opacity: ${backgroundOpacity};
  position: fixed;
  right: 0;
  top: 0;

  ${({
  transitionName,
  transitionTime
}) => (0, _styledComponents.css)`
    &.${transitionName}-enter, .${transitionName}-appear {
      opacity: 0;
    }

    &.${transitionName}-enter.${transitionName}-enter-active,
      &.${transitionName}-appear.${transitionName}-appear-active {
      opacity: ${backgroundOpacity};
      transition: opacity ${transitionTime}ms ease-out;
    }

    &.${transitionName}-exit {
      opacity: ${backgroundOpacity};
    }

    &.${transitionName}-exit.${transitionName}-exit-active {
      opacity: 0;
      transition: opacity ${transitionTime}ms 100ms ease-out;
    }
  `};
`;
const StyledModal = exports.StyledModal = _styledComponents.default.div`
  position: absolute;
  z-index: ${({
  theme,
  topModalOverride
}) => `${topModalOverride ? theme.zIndex.notification : theme.zIndex.modal}`};

  ${({
  transitionName,
  transitionTime
}) => (0, _styledComponents.css)`
    .${transitionName}-enter, .${transitionName}-appear {
      opacity: 0;
    }

    .${transitionName}-enter.${transitionName}-enter-active,
      .${transitionName}-appear.${transitionName}-appear-active {
      opacity: 1;
      transition: all ${transitionTime}ms 100ms ease-out;
    }

    .${transitionName}-exit {
      opacity: 1;
    }

    .${transitionName}-exit.${transitionName}-exit-active {
      opacity: 0;
      transition: all ${transitionTime}ms ease-out;
    }
  `}
`;
StyledModal.defaultProps = {
  theme: _base.default
};