"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.ModalContext = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _reactTransitionGroup = require("react-transition-group");
var _useScrollBlock = _interopRequireDefault(require("../../hooks/__internal__/useScrollBlock"));
var _portal = _interopRequireDefault(require("../portal"));
var _events = _interopRequireDefault(require("../../__internal__/utils/helpers/events"));
var _useModalManager = _interopRequireDefault(require("../../hooks/__internal__/useModalManager"));
var _modal = require("./modal.style");
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
const ModalContext = exports.ModalContext = /*#__PURE__*/_react.default.createContext({});
const Modal = ({
  children,
  open,
  onCancel,
  disableEscKey = false,
  disableClose,
  enableBackgroundUI = false,
  timeout = 300,
  topModalOverride,
  ...rest
}) => {
  const ref = (0, _react.useRef)(null);
  const backgroundNodeRef = (0, _react.useRef)(null);
  const contentNodeRef = (0, _react.useRef)(null);
  const [isAnimationComplete, setAnimationComplete] = (0, _react.useState)(false);
  const [triggerRefocusFlag, setTriggerRefocusFlag] = (0, _react.useState)(false);
  const {
    blockScroll,
    allowScroll
  } = (0, _useScrollBlock.default)();
  (0, _react.useEffect)(() => {
    if (enableBackgroundUI) {
      return;
    }
    if (open) {
      blockScroll();
    } else {
      allowScroll();
    }
  }, [allowScroll, blockScroll, enableBackgroundUI, open]);
  (0, _react.useEffect)(() => {
    return () => {
      if (!enableBackgroundUI) {
        allowScroll();
      }
    };
  }, [allowScroll, enableBackgroundUI]);
  const closeModal = (0, _react.useCallback)(ev => {
    if (onCancel && !disableClose && !disableEscKey && _events.default.isEscKey(ev)) {
      ev.stopImmediatePropagation();
      onCancel(ev);
    }
  }, [disableClose, disableEscKey, onCancel]);
  (0, _useModalManager.default)({
    open,
    closeModal,
    modalRef: ref,
    setTriggerRefocusFlag,
    topModalOverride
  });
  let background;
  let content;
  if (open) {
    background = !enableBackgroundUI ? /*#__PURE__*/_react.default.createElement(_modal.StyledModalBackground, {
      ref: backgroundNodeRef,
      "data-element": "modal-background",
      transitionName: "modal-background",
      transitionTime: timeout
    }) : null;
    content = children;
  }
  return /*#__PURE__*/_react.default.createElement(_portal.default, null, /*#__PURE__*/_react.default.createElement(_modal.StyledModal, _extends({
    "data-state": open ? "open" : "closed",
    transitionName: "modal",
    transitionTime: timeout,
    topModalOverride: topModalOverride,
    ref: ref
  }, rest), /*#__PURE__*/_react.default.createElement(_reactTransitionGroup.TransitionGroup, null, background && /*#__PURE__*/_react.default.createElement(_reactTransitionGroup.CSSTransition, {
    nodeRef: backgroundNodeRef,
    key: "modal",
    appear: true,
    classNames: "modal-background",
    timeout: timeout,
    onEntered: () => setAnimationComplete(true),
    onExiting: () => setAnimationComplete(false)
  }, background)), /*#__PURE__*/_react.default.createElement(_reactTransitionGroup.TransitionGroup, null, content && /*#__PURE__*/_react.default.createElement(_reactTransitionGroup.CSSTransition, {
    nodeRef: contentNodeRef,
    appear: true,
    classNames: "modal",
    timeout: timeout
  }, /*#__PURE__*/_react.default.createElement(ModalContext.Provider, {
    value: {
      isAnimationComplete,
      triggerRefocusFlag,
      isInModal: true
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    ref: contentNodeRef
  }, content))))));
};
var _default = exports.default = Modal;