import React from "react";
import { TagProps } from "../../__internal__/utils/helpers/tags";
export interface ModalContextProps {
    isInModal?: boolean;
    isAnimationComplete?: boolean;
    triggerRefocusFlag?: boolean;
}
export declare const ModalContext: React.Context<ModalContextProps>;
export interface ModalProps extends TagProps {
    /** Custom class name  */
    className?: string;
    /** Modal content */
    children?: React.ReactNode;
    /** The ARIA role to be applied to the modal */
    ariaRole?: string;
    /** Determines if the Esc Key closes the modal */
    disableEscKey?: boolean;
    /** Determines if the Dialog can be closed */
    disableClose?: boolean;
    /** Determines if the background is disabled when the modal is open */
    enableBackgroundUI?: boolean;
    /** A custom close event handler */
    onCancel?: (ev: React.KeyboardEvent<HTMLElement>) => void;
    /** Sets the open state of the modal */
    open: boolean;
    /** Transition time */
    timeout?: number;
    /** Manually override the internal modal stacking order to set this as top */
    topModalOverride?: boolean;
}
declare const Modal: ({ children, open, onCancel, disableEscKey, disableClose, enableBackgroundUI, timeout, topModalOverride, ...rest }: ModalProps) => React.JSX.Element;
export default Modal;
