"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.ScrollableBlock = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _menu = _interopRequireDefault(require("../menu.context"));
var _menuItem = _interopRequireDefault(require("../menu-item"));
var _scrollableBlock = _interopRequireDefault(require("./scrollable-block.style"));
var _box = _interopRequireDefault(require("../../box"));
var _tags = _interopRequireDefault(require("../../../__internal__/utils/helpers/tags"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
const ScrollableBlock = ({
  children,
  height,
  variant = "default",
  parent,
  parentVariant,
  ...rest
}) => {
  const {
    menuType
  } = (0, _react.useContext)(_menu.default);
  const scrollVariants = {
    light: "light",
    dark: "dark",
    white: "light",
    black: "dark"
  };
  return /*#__PURE__*/_react.default.createElement(_scrollableBlock.default, _extends({}, (0, _tags.default)("submenu-scrollable-block", rest), {
    menuType: menuType,
    variant: variant
  }, rest), parent && /*#__PURE__*/_react.default.createElement(_menuItem.default, {
    "data-component": "scrollable-block-parent",
    overrideColor: true,
    variant: parentVariant,
    p: "2px 16px",
    as: "div"
  }, parent), /*#__PURE__*/_react.default.createElement(_box.default, {
    overflowY: "scroll",
    scrollVariant: scrollVariants[menuType],
    height: height,
    p: 0,
    as: "ul",
    role: "list"
  }, children));
};
exports.ScrollableBlock = ScrollableBlock;
var _default = exports.default = ScrollableBlock;