"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StyledMenuWrapper = exports.StyledMenuItem = void 0;
var _styledComponents = _interopRequireWildcard(require("styled-components"));
var _styledSystem = require("styled-system");
var _menu = _interopRequireDefault(require("./menu.config"));
var _verticalDivider = require("../vertical-divider/vertical-divider.style");
var _link = require("../link/link.style");
var _themes = require("../../style/themes");
var _menuItem = _interopRequireDefault(require("./menu-item/menu-item.style"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const StyledMenuWrapper = exports.StyledMenuWrapper = _styledComponents.default.ul`
  line-height: 40px;
  list-style: none;
  margin: 0;
  padding: 0;
  outline: none;
  display: flex;

  ${_styledSystem.layout}
  ${_styledSystem.flexbox}

  ${_verticalDivider.StyledVerticalWrapper} {
    ${({
  menuType
}) => menuType && (0, _styledComponents.css)`
        display: inline-block;
        vertical-align: bottom;
        background-color: ${_menu.default[menuType].background};
        ${menuType === "dark" && (0, _styledComponents.css)`
          color: ${_menu.default[menuType].color};
        `}
      `}
    ${_verticalDivider.StyledDivider} {
      position: relative;
      top: -1px;
    }
  }
`;
const StyledMenuItem = exports.StyledMenuItem = _styledComponents.default.li`
  ${_styledSystem.layout}
  ${_styledSystem.flexbox}

  ${_link.StyledLink} a:focus, ${_link.StyledLink} button:focus {
    border-radius: var(--borderRadius000);
  }

  ${({
  inSubmenu
}) => (0, _styledComponents.css)`
    ${inSubmenu && (0, _styledComponents.css)`
      display: list-item;
    `}
  `}

  ${({
  inFullscreenView
}) => inFullscreenView && (0, _styledComponents.css)`
      padding-top: var(--spacing200);
      padding-bottom: var(--spacing200);

      > a,
      ${_link.StyledLink} > a,
      > button,
      ${_link.StyledLink} > button,
      > span,
      > div,
      [data-component="submenu-wrapper"] > ${_link.StyledLink} {
        width: 100%;
        box-sizing: border-box;
      }
    `}

  ${_menuItem.default} {
    ${_styledSystem.padding}
  }
`;
StyledMenuItem.defaultProps = {
  theme: _themes.baseTheme
};