"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Menu = void 0;
Object.defineProperty(exports, "MenuContext", {
  enumerable: true,
  get: function () {
    return _menu2.default;
  }
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _menu = require("./menu.style");
var _tags = _interopRequireDefault(require("../../__internal__/utils/helpers/tags"));
var _menu2 = _interopRequireDefault(require("./menu.context"));
var _keyboardNavigation = require("./__internal__/keyboard-navigation");
var _locators = require("./__internal__/locators");
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
const Menu = ({
  menuType = "light",
  children,
  ...rest
}) => {
  const [openSubmenuId, setOpenSubmenuId] = (0, _react.useState)(null);
  const ref = (0, _react.useRef)(null);
  const [focusId, setFocusId] = (0, _react.useState)(undefined);
  const [itemIds, setItemIds] = (0, _react.useState)([]);
  const registerItem = (0, _react.useCallback)(id => {
    setItemIds(prevState => {
      return [...prevState, id];
    });
  }, []);
  const unregisterItem = (0, _react.useCallback)(id => {
    setItemIds(prevState => {
      return prevState.filter(itemId => itemId !== id);
    });
  }, []);
  const handleKeyDown = event => {
    /* istanbul ignore else */
    if (ref.current) {
      const focusableItems = ref.current.querySelectorAll(_locators.MENU_ITEM_CHILDREN_LOCATOR);

      /* istanbul ignore else */
      if (focusableItems) {
        const newIndex = (0, _keyboardNavigation.menuKeyboardNavigation)(event, Array.from(focusableItems));

        /* istanbul ignore else */
        if (newIndex !== undefined) {
          setFocusId(itemIds[newIndex]);
        }
      }
    }
  };
  return /*#__PURE__*/_react.default.createElement(_menu.StyledMenuWrapper, _extends({
    menuType: menuType
  }, rest, (0, _tags.default)("menu", rest), {
    ref: ref,
    role: "list",
    onKeyDown: handleKeyDown
  }), /*#__PURE__*/_react.default.createElement(_menu2.default.Provider, {
    value: {
      menuType,
      inMenu: true,
      openSubmenuId,
      setOpenSubmenuId,
      focusId,
      registerItem,
      unregisterItem
    }
  }, children));
};
exports.Menu = Menu;
var _default = exports.default = Menu;