import React from "react";
import { VariantType } from "../menu-item";
import { TagProps } from "../../../__internal__/utils/helpers/tags";
declare const AS_VALUES: readonly ["h2", "h3", "h4", "h5", "h6"];
declare type AllowedAsValues = typeof AS_VALUES[number];
export interface MenuTitleProps extends TagProps {
    children?: React.ReactNode;
    text: string;
    /** Set the colour variant for a menuType */
    variant?: VariantType;
    /** Set the heading level for the segment title */
    as?: AllowedAsValues;
}
declare const MenuSegmentTitle: React.ForwardRefExoticComponent<MenuTitleProps & React.RefAttributes<HTMLDivElement>>;
export default MenuSegmentTitle;
