"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _styledComponents = _interopRequireWildcard(require("styled-components"));
var _styledSystem = require("styled-system");
var _link = require("../../link/link.style");
var _icon = _interopRequireDefault(require("../../icon/icon.style"));
var _iconButton = _interopRequireDefault(require("../../icon-button/icon-button.style"));
var _menu = _interopRequireDefault(require("../menu.config"));
var _link2 = _interopRequireDefault(require("../../link"));
var _addFocusStyling = _interopRequireDefault(require("../../../style/utils/add-focus-styling"));
var _themes = require("../../../style/themes");
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const oldFocusStyling = `
  box-shadow: inset 0 0 0 var(--borderWidth300) var(--colorsSemanticFocus500);
`;
const StyledMenuItemWrapper = _styledComponents.default.a.attrs({
  as: _link2.default
})`
  ${({
  menuType,
  selected,
  hasSubmenu,
  isOpen,
  variant,
  showDropdownArrow,
  href,
  clickToOpen,
  maxWidth,
  inFullscreenView,
  overrideColor,
  asPassiveItem,
  asDiv,
  hasInput
}) => (0, _styledComponents.css)`
    ${!inFullscreenView && (0, _styledComponents.css)`
        ${_styledSystem.padding}
      `}
    display: inline-block;
    font-size: 14px;
    font-weight: 700;
    height: 40px;
    position: relative;
    box-shadow: none;

    a,
    button {
      cursor: pointer;
    }

      a:focus,
      button:focus {
        ${({
  theme
}) => `${!theme.focusRedesignOptOut ? (0, _addFocusStyling.default)(true) : /* istanbul ignore next */oldFocusStyling}`}
      }
    }

    ${!overrideColor && (0, _styledComponents.css)`
        background-color: ${_menu.default[menuType].background};
      `}

    ${overrideColor && (0, _styledComponents.css)`
        &&&& {
          background-color: ${variant === "alternate" ? _menu.default[menuType].alternate : _menu.default[menuType].submenuItemBackground};
        }
      `}

    ${!inFullscreenView && (0, _styledComponents.css)`
        max-width: inherit;

        && {
          a:focus,
          button:focus {
            background-color: ${_menu.default[menuType].background};
            color: ${_menu.default[menuType].color};
            z-index: 1;
            position: relative;
          }
        }

        &&& {
          a,
          button {
            ${maxWidth && (0, _styledComponents.css)`
              box-sizing: border-box;
              max-width: inherit;
              text-overflow: ellipsis;
              overflow: hidden;
              white-space: nowrap;
              vertical-align: bottom;
            `}
          }

          a:hover,
          button:hover {
            ${!asDiv && (0, _styledComponents.css)`
              background-color: var(--colorsComponentsMenuAutumnStandard600);
              color: var(--colorsComponentsMenuYang100);

              [data-component="icon"] {
                color: var(--colorsComponentsMenuYang100);
              }
            `}

            ::before {
              border-top-color: var(--colorsComponentsMenuYang100);
            }
          }
        }
      `}

    ${asPassiveItem ? `
        ${_iconButton.default} {
          > span {
            display: inline-flex;
            margin-right: 0;
          }

          :focus {
            outline: none;
            [data-component="icon"] {
              color: ${_menu.default[menuType].color};
            }
          }
        }
      ` : `
        a,
        ${_link.StyledLink} a,
        button,
        ${_link.StyledLink} button {
          padding: 0 16px;
        }
      `}

    button,
    ${_link.StyledLink} button {
      line-height: 40px;
      height: 40px;
      margin: 0px;
      text-align: left;
    }

    &&& {
      a,
      button,
      [data-component="icon"],
      ${_link.StyledLink} a,
      ${_link.StyledLink} button,
      ${_link.StyledLink} [data-component="icon"] {
        font-weight: 700;
        text-decoration: none;
        ${!hasInput && `color: ${_menu.default[menuType].color};`}
      }

      ${!inFullscreenView && (0, _styledComponents.css)`
          a > ${_icon.default}, button > ${_icon.default} {
            display: inline-block;
          }
        `}
    }

    ${selected && (0, _styledComponents.css)`
        background-color: ${_menu.default[menuType].selected};

        a:focus,
        button:focus {
          background-color: ${_menu.default[menuType].selected};
        }

        a:hover,
        button:hover {
          background-color: var(--colorsComponentsMenuAutumnStandard600);
        }
      `}

    ${variant === "alternate" && !inFullscreenView && (0, _styledComponents.css)`
        &&& {
          background-color: ${_menu.default[menuType].alternate};
        }

        &&& a:focus,
        &&& button:focus {
          background-color: ${_menu.default[menuType].alternate};
        }

        ${!hasInput && (0, _styledComponents.css)`
          &&& a:hover,
          &&& button:hover {
            background-color: ${_menu.default[menuType].alternateHover};
          }
        `}
      `}

    ${isOpen && (0, _styledComponents.css)`
        a,
        button {
          background-color: ${_menu.default[menuType].submenuItemBackground};
          color: ${_menu.default[menuType].color};
        }
      `}

    ${hasSubmenu && (0, _styledComponents.css)`
        background-color: ${_menu.default[menuType].submenuBackground};

        a:focus,
        button:focus {
          background-color: ${_menu.default[menuType].submenuBackground};
          color: ${_menu.default[menuType].color};

          [data-component="icon"] {
            color: ${_menu.default[menuType].color};
          }

          ${clickToOpen && isOpen && (0, _styledComponents.css)`
            background-color: ${_menu.default[menuType].submenuOpenedBackground};
          `}
        }

        a:hover,
        button:hover {
          background-color: ${_menu.default[menuType].submenuOpenedBackground};
          color: var(--colorsComponentsMenuYang100);

          ${!(href || clickToOpen) && (0, _styledComponents.css)`
            cursor: default;
            background-color: ${_menu.default[menuType].submenuItemBackground};
            color: ${_menu.default[menuType].color};
          `}

          [data-component="icon"] {
            color: ${_menu.default[menuType].color};
          }
        }

        ${selected && (0, _styledComponents.css)`
          background-color: ${_menu.default[menuType].submenuSelected};

          a:focus,
          button:focus {
            background-color: ${_menu.default[menuType].submenuSelected};
          }

          a:hover,
          button:hover {
            background-color: var(--colorsComponentsMenuAutumnStandard600);
            color: var(--colorsComponentsMenuYang100);
          }
        `}

        ${showDropdownArrow && (0, _styledComponents.css)`
          > a,
          > button:not(${_iconButton.default}) {
            padding-right: 32px;
          }

          a::before,
          button::before {
            display: block;
            margin-top: -2px;
            pointer-events: none;
            position: absolute;
            right: 16px;
            top: 50%;
            z-index: 2;
            content: "";
            width: 0;
            height: 0;
            border-width: 5px 4px 4px;
            border-style: solid;
            border-top-color: initial;
            border-right-color: transparent;
            border-bottom-color: transparent;
            border-left-color: transparent;
          }
        `}
      `}

    ${inFullscreenView && (0, _styledComponents.css)`
      ${asDiv && (0, _styledComponents.css)`
          &&& {
            > a,
            > button {
              color: ${_menu.default[menuType].title};
              outline: none;
            }

            > button:hover,
            > a:hover {
              background-color: transparent;
              cursor: default;
              outline: none;
              color: ${_menu.default[menuType].title};
            }
          }
        `}

      ${asPassiveItem && (0, _styledComponents.css)`
          cursor: default;
          padding: 0 16px;

          :hover {
            background: transparent;
          }
        `}

      a,
      ${_link.StyledLink} a,
      button,
      ${_link.StyledLink} button {
        width: 100vw;
        box-sizing: border-box;
      }

      a:focus,
      button:focus {
        z-index: 1;
        position: relative;
      }

      && {
        > a:focus,
        > a:hover,
        > button:focus,
        > button:hover {
          background-color: var(--colorsComponentsMenuAutumnStandard600);
          color: var(--colorsComponentsMenuYang100);

            ${!hasInput && `
              [data-component="icon"] {
                color: var(--colorsComponentsMenuYang100);
              }
            `}
          }
        }
      }
    `}
  `}
`;
StyledMenuItemWrapper.defaultProps = {
  theme: _themes.baseTheme
};
var _default = exports.default = StyledMenuItemWrapper;