"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.MenuItem = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _invariant = _interopRequireDefault(require("invariant"));
var _utils = require("../../../style/utils");
var _menuItem = _interopRequireDefault(require("./menu-item.style"));
var _events = _interopRequireDefault(require("../../../__internal__/utils/helpers/events"));
var _menu = _interopRequireDefault(require("../menu.context"));
var _submenu = _interopRequireDefault(require("../__internal__/submenu/submenu.component"));
var _submenu2 = _interopRequireDefault(require("../__internal__/submenu/submenu.context"));
var _menu2 = require("../menu.style");
var _guid = _interopRequireDefault(require("../../../__internal__/utils/helpers/guid"));
var _tags = _interopRequireDefault(require("../../../__internal__/utils/helpers/tags"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
const MenuItem = ({
  submenu,
  children,
  href,
  onClick,
  target,
  submenuDirection = "right",
  icon,
  selected,
  onKeyDown,
  variant = "default",
  showDropdownArrow = true,
  ariaLabel,
  clickToOpen,
  maxWidth,
  onSubmenuOpen,
  onSubmenuClose,
  overrideColor,
  rel,
  as,
  ...rest
}) => {
  !(icon || children) ? process.env.NODE_ENV !== "production" ? (0, _invariant.default)(false, "Either prop `icon` must be defined or this node must have `children`.") : (0, _invariant.default)(false) : void 0;
  !(children || ariaLabel || typeof submenu === "string") ? process.env.NODE_ENV !== "production" ? (0, _invariant.default)(false, "If no text is provided an `ariaLabel` should be given to facilitate accessibility.") : (0, _invariant.default)(false) : void 0;
  const {
    inFullscreenView,
    registerItem,
    unregisterItem,
    focusId,
    menuType,
    openSubmenuId
  } = (0, _react.useContext)(_menu.default);
  const menuItemId = (0, _react.useRef)((0, _guid.default)());
  const submenuContext = (0, _react.useContext)(_submenu2.default);
  const {
    submenuFocusId,
    updateFocusId: updateSubmenuFocusId,
    handleKeyDown: handleSubmenuKeyDown,
    shiftTabPressed
  } = submenuContext;
  const ref = (0, _react.useRef)(null);
  const focusFromMenu = focusId === menuItemId.current;
  const focusFromSubmenu = submenuFocusId ? submenuFocusId === menuItemId.current : undefined;
  const inputRef = (0, _react.useRef)(null);
  inputRef.current = ref.current ? ref.current.querySelector("[data-element='input']") : null;
  const focusRef = inputRef.current ? inputRef : ref;
  (0, _react.useEffect)(() => {
    const id = menuItemId.current;
    if (registerItem) {
      registerItem(id);
    }
    return () => {
      if (unregisterItem) {
        unregisterItem(id);
      }
    };
  }, [registerItem, unregisterItem]);
  (0, _react.useEffect)(() => {
    const inputIcon = ref.current?.querySelector("[data-element='input-icon-toggle']");
    if (!openSubmenuId && focusFromSubmenu === undefined && focusFromMenu) {
      /* istanbul ignore else */
      if (focusRef.current) {
        focusRef.current?.focus();
      }
    } else if (focusFromSubmenu && !(shiftTabPressed && inputIcon?.getAttribute("tabindex") === "0")) {
      /* istanbul ignore else */
      if (focusRef.current) {
        focusRef.current?.focus();
      }
    }
  }, [openSubmenuId, focusFromMenu, focusFromSubmenu, shiftTabPressed, focusRef]);
  const updateFocusOnClick = (0, _react.useCallback)(() => {
    if (updateSubmenuFocusId) {
      updateSubmenuFocusId(menuItemId.current);
    }
  }, [updateSubmenuFocusId]);
  const handleKeyDown = (0, _react.useCallback)(event => {
    if (onKeyDown) {
      onKeyDown(event);
    }
    if (ref.current && _events.default.isEscKey(event)) {
      ref.current?.focus();
    }
    const inputIcon = ref.current?.querySelector("[data-element='input-icon-toggle']");
    const shouldFocusIcon = inputIcon?.getAttribute("tabindex") === "0" && document.activeElement === inputRef.current && inputRef.current?.value;

    // let natural tab order move focus if input icon is tabbable or input with button exists
    if (_events.default.isTabKey(event) && (!_events.default.isShiftKey(event) && shouldFocusIcon || _events.default.isShiftKey(event) && document.activeElement === inputIcon)) {
      return;
    }
    if (handleSubmenuKeyDown) {
      handleSubmenuKeyDown(event);
    }
  }, [onKeyDown, handleSubmenuKeyDown]);
  const elementProps = {
    className: href || onClick ? "carbon-menu-item--has-link" : "",
    href,
    target,
    rel,
    onClick,
    icon,
    removeAriaLabelOnIcon: true,
    selected,
    variant,
    onKeyDown: !inFullscreenView ? handleKeyDown : undefined,
    overrideColor,
    ref
  };
  const getTitle = title => maxWidth && typeof title === "string" ? title : undefined;
  const itemMaxWidth = !inFullscreenView ? maxWidth : undefined;
  const asPassiveItem = !(onClick || href);
  const hasInput = !!inputRef.current;
  if (submenu) {
    return /*#__PURE__*/_react.default.createElement(_menu2.StyledMenuItem, _extends({}, (0, _tags.default)("menu-item", rest), {
      menuType: menuType,
      title: getTitle(submenu),
      maxWidth: itemMaxWidth,
      onClick: updateFocusOnClick
    }, rest, {
      inFullscreenView: inFullscreenView,
      id: menuItemId.current,
      as: as
    }), /*#__PURE__*/_react.default.createElement(_submenu.default, _extends({}, typeof submenu !== "boolean" && {
      title: submenu
    }, {
      submenuDirection: submenuDirection,
      showDropdownArrow: showDropdownArrow,
      clickToOpen: clickToOpen,
      maxWidth: maxWidth,
      asPassiveItem: asPassiveItem,
      ariaLabel: ariaLabel,
      onSubmenuOpen: onSubmenuOpen,
      onSubmenuClose: onSubmenuClose
    }, elementProps, rest), children));
  }
  const paddingProps = (0, _utils.filterStyledSystemPaddingProps)(rest);
  return /*#__PURE__*/_react.default.createElement(_menu2.StyledMenuItem, _extends({}, (0, _tags.default)("menu-item", rest), {
    menuType: menuType,
    inSubmenu: !!handleSubmenuKeyDown,
    title: getTitle(children),
    maxWidth: itemMaxWidth
  }, rest, {
    inFullscreenView: inFullscreenView && !Object.keys(submenuContext).length,
    id: menuItemId.current,
    onClick: updateFocusOnClick,
    as: as
  }), /*#__PURE__*/_react.default.createElement(_menuItem.default, _extends({
    menuType: menuType
  }, elementProps, {
    ariaLabel: ariaLabel,
    maxWidth: maxWidth,
    inFullscreenView: inFullscreenView,
    asPassiveItem: asPassiveItem,
    placeholderTabIndex: asPassiveItem
  }, paddingProps, {
    asDiv: hasInput || as === "div",
    hasInput: hasInput
  }), children));
};
exports.MenuItem = MenuItem;
MenuItem.displayName = "MenuItem";
var _default = exports.default = MenuItem;